/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.supermarket.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.confadmin.mapper.KmsDirectStoreMapper;
import com.biz.crm.confadmin.model.KmsDirectStoreEntity;
import com.biz.crm.config.KmsConfig;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.grabrule.mapper.KmsGrabRuleMapper;
import com.biz.crm.grabrule.model.KmsGrabRuleEntity;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectAccountReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectCustomerOrgReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectAccountRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectCustomerOrgRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectAccountMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.supermarket.mapper.KmsTotalWarehouseStoreMapper;
import com.biz.crm.supermarket.model.KmsTenantryDirectAccountEntity;
import com.biz.crm.supermarket.model.KmsTenantryDirectCustomerOrgEntity;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import com.biz.crm.supermarket.model.KmsTotalWarehouseStoreEntity;
import com.biz.crm.util.AesEncoder;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KmsTenantryDirectHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsTenantryDirectHelper.class);
    @Resource
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper tenantryDirectCustomerOrgMapper;
    @Resource
    private KmsTenantryDirectAccountMapper tenantryDirectAccountMapper;
    @Resource
    private KmsTenantryDirectStoreMapper tenantryDirectStoreMapper;
    @Resource
    private KmsDirectStoreMapper kmsDirectStoreMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private KmsConfig kmsConfig;
    @Resource
    private KmsGrabRuleMapper kmsGrabRuleMapper;
    @Resource
    private KmsTotalWarehouseStoreMapper kmsTotalWarehouseStoreMapper;
    private static final Integer MAX_PASS_LENGTH = 32;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertData(List<KmsTenantryDirectCustomerOrgRespVo> list) {
        List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
        Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
        Map<String, Map<String, String>> dataMap = this.getDictMaps();
        HashSet cusOrgSet = Sets.newHashSet();
        list.forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)o.getEnableStatus())) {
                o.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
            }
            cusOrgSet.add(o.getCustomerOrgId());
            o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
        });
        CusOrgVo vo = new CusOrgVo();
        vo.setIds((List)Lists.newArrayList((Iterable)cusOrgSet));
        vo.setPageSize(Integer.valueOf(cusOrgSet.size()));
        List cusOrgVos = ((PageResult)ApiResultUtil.objResult((Result)this.mdmCusOrgFeign.list(vo), (boolean)true)).getData();
        Map<String, String> map = cusOrgVos.stream().collect(Collectors.toMap(CusOrgVo::getCustomerOrgCode, CusOrgVo::getCustomerOrgName));
        list.forEach(x -> {
            if (map.containsKey(x.getCustomerOrgCode())) {
                x.setCustomerOrgName((String)map.get(x.getCustomerOrgCode()));
            }
        });
    }

    public void convertAccountDate(List<KmsTenantryDirectAccountRespVo> list) {
        Map<String, Map<String, String>> dataMap = this.getDictMaps();
        List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
        Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
        list.forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)o.getEnableStatus())) {
                o.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
            }
            o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
        });
    }

    public List<KmsTenantryDirectCustomerOrgEntity> checkSaveData(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        this.checkTenantryDirect(reqVo);
        CusOrgVo cusOrgVo = (CusOrgVo)ApiResultUtil.objResult((Result)this.mdmCusOrgFeign.query(reqVo.getCustomerOrgId(), ""), (boolean)true);
        reqVo.setCustomerOrgCode(cusOrgVo.getCustomerOrgCode());
        reqVo.setCustomerOrgName(cusOrgVo.getCustomerOrgName());
        return this.checkDataExist(reqVo);
    }

    private void checkTenantryDirect(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectId(), (String)"\u5546\u8d85\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerOrgId(), (String)"\u7ec4\u7ec7\u5ba2\u6237\u4fe1\u606f\u5fc5\u586b");
    }

    private List<KmsTenantryDirectCustomerOrgEntity> checkDataExist(KmsTenantryDirectCustomerOrgReqVo reqVo) {
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVoForId = new KmsTenantryDirectCustomerOrgReqVo();
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVoForCode = new KmsTenantryDirectCustomerOrgReqVo();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            customerOrgReqVoForCode.setId(reqVo.getId());
            customerOrgReqVoForId.setId(reqVo.getId());
        }
        customerOrgReqVoForCode.setBsDirectSystemCode(reqVo.getBsDirectSystemCode());
        customerOrgReqVoForId.setDirectId(reqVo.getDirectId());
        List<KmsTenantryDirectCustomerOrgEntity> entitiesByCode = this.tenantryDirectCustomerOrgMapper.selectListByCompetenceForExist(customerOrgReqVoForCode);
        List<KmsTenantryDirectCustomerOrgEntity> entitiesById = this.tenantryDirectCustomerOrgMapper.selectListByCompetenceForExist(customerOrgReqVoForId);
        if (CollectionUtils.isNotEmpty(entitiesById)) {
            if (entitiesById.get(0).getEnableStatus().equals(CrmEnableStatusEnum.ENABLE.getCode()) && entitiesById.get(0).getDelFlag().equals(CrmDelFlagEnum.NORMAL.getCode())) {
                throw new BusinessException("\u76f4\u8425\u4fe1\u606f\u5df2\u7ecf\u88ab\u7ef4\u62a4");
            }
            return entitiesById;
        }
        if (CollectionUtils.isNotEmpty(entitiesByCode)) {
            throw new BusinessException("\u76f4\u8425\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        return Lists.newArrayList();
    }

    public void checkSaveAccountData(KmsTenantryDirectAccountReqVo reqVo) {
        KmsTenantryDirectAccountEntity entity;
        this.checkNoEmptyAccountData(reqVo);
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId()) && (entity = (KmsTenantryDirectAccountEntity)this.tenantryDirectAccountMapper.selectById((Serializable)((Object)reqVo.getId()))).getLoginPass().equals(reqVo.getLoginPass())) {
            reqVo.setLoginPass(new AesEncoder(this.kmsConfig.getEncryptAesKey()).decode(reqVo.getLoginPass()));
            if (reqVo.getConfirmPass().equals(entity.getLoginPass())) {
                reqVo.setConfirmPass(new AesEncoder(this.kmsConfig.getEncryptAesKey()).decode(reqVo.getConfirmPass()));
            }
        }
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)reqVo.getLoginPass(), (CharSequence)reqVo.getConfirmPass()), (String)"\u767b\u5f55\u5bc6\u7801\u548c\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4");
        reqVo.setLoginPass(new AesEncoder(this.kmsConfig.getEncryptAesKey()).encode((CharSequence)reqVo.getLoginPass()));
        if (reqVo.getLoginPass().length() > MAX_PASS_LENGTH) {
            throw new BusinessException("\u8f93\u5165\u5bc6\u7801\u8fc7\u957f");
        }
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setBsDirectSystemCode(reqVo.getBsDirectSystemCode());
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> tenantryDirectCustomerOrgEntities = this.tenantryDirectCustomerOrgMapper.selectListByCompetence(customerOrgReqVo);
        AssertUtils.isNotEmpty(tenantryDirectCustomerOrgEntities, (String)"\u6ca1\u6709\u6b63\u5728\u7ef4\u62a4\u4e2d\u7684\u76f4\u8425\u4f53\u7cfb");
        reqVo.setBsDirectSystemName(tenantryDirectCustomerOrgEntities.get(0).getBsDirectSystemName());
        reqVo.setBsDirectSystemId(tenantryDirectCustomerOrgEntities.get(0).getId());
        this.checkAccountExist(reqVo);
    }

    private void checkAccountExist(KmsTenantryDirectAccountReqVo reqVo) {
        KmsTenantryDirectAccountReqVo accountReqVo = new KmsTenantryDirectAccountReqVo();
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            accountReqVo.setId(reqVo.getId());
        }
        accountReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
        accountReqVo.setLoginAcc(reqVo.getLoginAcc());
        List<KmsTenantryDirectAccountEntity> entities = this.tenantryDirectAccountMapper.selectListByCompetenceForExist(accountReqVo);
        if (CollectionUtils.isNotEmpty(entities)) {
            throw new BusinessException("\u8be5\u5ba2\u6237\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
    }

    private void checkNoEmptyAccountData(KmsTenantryDirectAccountReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLoginAcc(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLoginPass(), (String)"\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getConfirmPass(), (String)"\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkAccountUpdate(KmsTenantryDirectAccountReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectAccountEntity entity = (KmsTenantryDirectAccountEntity)this.tenantryDirectAccountMapper.selectById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)entity, (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
    }

    public void convertStoreData(List<KmsTenantryDirectStoreRespVo> list) {
        Map<String, Map<String, String>> dataMap = this.getDictMaps();
        List<String> createOrgCodes = list.stream().map(CrmBaseVo::getCreateOrgCode).distinct().collect(Collectors.toList());
        Map<String, String> orgCompanyMap = KmsOrgUtil.findCompanyByCreateOrgCodes(createOrgCodes);
        list.forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)o.getEnableStatus())) {
                o.setEnableStatusName((String)((Map)Optional.ofNullable(dataMap.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
            }
            o.setOwnedCompany((String)orgCompanyMap.get(o.getCreateOrgCode()));
        });
    }

    public void setPublicParamsNull(CrmBaseEntity entity) {
        entity.setId(null);
        entity.setCreateCode(null);
        entity.setCreateDate(null);
        entity.setCreateDateSecond(null);
        entity.setCreateName(null);
        entity.setCreateOrgCode(null);
        entity.setCreatePosCode(null);
        entity.setCreateOrgName(null);
        entity.setCreatePosName(null);
    }

    public void checkSaveStoreData(KmsTenantryDirectStoreReqVo reqVo) {
        this.checkNoEmptyStoreDate(reqVo);
        KmsTenantryDirectCustomerOrgReqVo customerOrgReqVo = new KmsTenantryDirectCustomerOrgReqVo();
        customerOrgReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
        customerOrgReqVo.setBsDirectSystemCode(reqVo.getBsDirectSystemCode());
        customerOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<KmsTenantryDirectCustomerOrgEntity> tenantryDirectCustomerOrgEntities = this.tenantryDirectCustomerOrgMapper.selectListByCompetence(customerOrgReqVo);
        AssertUtils.isNotEmpty(tenantryDirectCustomerOrgEntities, (String)"\u6ca1\u6709\u5728\u7ef4\u62a4\u4e2d\u7684\u76f4\u8425\u4f53\u7cfb");
        KmsTenantryDirectCustomerOrgEntity tenantryDirectCustomerOrgEntity = tenantryDirectCustomerOrgEntities.get(0);
        reqVo.setBsDirectSystemName(tenantryDirectCustomerOrgEntity.getBsDirectSystemName());
        reqVo.setBsDirectSystemId(tenantryDirectCustomerOrgEntity.getId());
        MdmTerminalVo terminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.mdmTerminalFeign.query("", reqVo.getTerminalCode()), (boolean)true);
        reqVo.setTerminalName(terminalVo.getTerminalName());
        KmsDirectStoreEntity entity = (KmsDirectStoreEntity)this.kmsDirectStoreMapper.selectById((Serializable)((Object)reqVo.getStoreId()));
        if (entity == null) {
            throw new BusinessException("\u5546\u8d85\u95e8\u5e97\u4e0d\u5b58\u5728");
        }
        if (!entity.getDirectId().equals(tenantryDirectCustomerOrgEntities.get(0).getDirectId())) {
            throw new BusinessException("\u5546\u8d85\u95e8\u5e97\u4e0d\u5728\u7ef4\u62a4\u4e2d");
        }
        this.checkStoreExist(reqVo);
    }

    private void checkStoreExist(KmsTenantryDirectStoreReqVo reqVo) {
        List<KmsTenantryDirectStoreEntity> entities;
        KmsTenantryDirectStoreReqVo storeReqVo = new KmsTenantryDirectStoreReqVo();
        storeReqVo.setBsDirectSystemId(reqVo.getBsDirectSystemId());
        storeReqVo.setTerminalCode(reqVo.getTerminalCode());
        storeReqVo.setStoreId(reqVo.getStoreId());
        storeReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isNotBlank((CharSequence)reqVo.getId())) {
            storeReqVo.setId(reqVo.getId());
        }
        if (CollectionUtils.isNotEmpty(entities = this.tenantryDirectStoreMapper.selectListByCompetenceForExist(storeReqVo))) {
            throw new BusinessException("\u8be5\u6570\u636e\u5df2\u5b58\u5728");
        }
    }

    private void checkNoEmptyStoreDate(KmsTenantryDirectStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbId[bsDirectSystemId]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemCode(), (String)"\u76f4\u8425\u4f53\u7cfb\u7f16\u7801[bsDirectSystemCode]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBsDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0[bsDirectSystemName]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getStoreId(), (String)"\u5546\u8d85\u95e8\u5e97id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getStoreCode(), (String)"\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getStoreName(), (String)"\u5546\u8d85\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u4f01\u4e1a\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkStoreUpdate(KmsTenantryDirectStoreReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        KmsTenantryDirectStoreEntity storeEntity = (KmsTenantryDirectStoreEntity)this.tenantryDirectStoreMapper.selectById((Serializable)((Object)reqVo.getId()));
        AssertUtils.isNotNull((Object)storeEntity, (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
    }

    public void checkDelete(List<String> ids) {
        List warehouseStores;
        List grabRules;
        List stores;
        List products;
        if (CollectionUtils.isNotEmpty(ids)) {
            return;
        }
        List accounts = this.tenantryDirectAccountMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectAccountEntity::getBsDirectSystemId, ids)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        StringBuilder stringBuffer = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            stringBuffer.append("\u76f4\u8425\u4f53\u7cfb\u4e0b\u5b58\u5728\u5ba2\u6237\u8d26\u53f7\u3001");
        }
        if (CollectionUtils.isNotEmpty((Collection)(products = this.kmsTenantryDirectProductMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(KmsTenantryDirectProductEntity::getBsDirectSystemId, ids))))) {
            stringBuffer.append("\u76f4\u8425\u4f53\u7cfb\u4e0b\u5b58\u5728\u5ba2\u6237\u8d26\u53f7\u3001");
        }
        if (CollectionUtils.isNotEmpty((Collection)(stores = this.tenantryDirectStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTenantryDirectStoreEntity::getBsDirectSystemId, ids)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()))))) {
            stringBuffer.append("\u76f4\u8425\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u95e8\u5e97\u3001");
        }
        if (CollectionUtils.isNotEmpty((Collection)(grabRules = this.kmsGrabRuleMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(KmsGrabRuleEntity::getBsDirectSystemId, ids))))) {
            stringBuffer.append("\u76f4\u8425\u4f53\u7cfb\u4e0b\u5b58\u5728\u6293\u5355\u89c4\u5219\u3001");
        }
        if (CollectionUtils.isNotEmpty((Collection)(warehouseStores = this.kmsTotalWarehouseStoreMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(KmsTotalWarehouseStoreEntity::getBsDirectSystemId, ids)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()))))) {
            stringBuffer.append("\u76f4\u8425\u4f53\u7cfb\u5b58\u5728\u5927\u4ed3\u3001");
        }
        if (StringUtils.isNotBlank((CharSequence)stringBuffer)) {
            stringBuffer.append("\u4e0d\u53ef\u5220\u9664");
            throw new BusinessException(stringBuffer.toString());
        }
    }
}

