/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.trans.helper;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.kaproduct.mapper.KmsProductUnitMapper;
import com.biz.crm.kaproduct.mapper.KmsTenantryDirectProductMapper;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalSupplyFeign;
import com.biz.crm.nebular.kms.kaproduct.req.KmsProductUnitReqVo;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsProductUnitRespVo;
import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsSupplierReqVo;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsSupplierRespVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.supermarket.mapper.KmsSupplierMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectStoreMapper;
import com.biz.crm.trans.vo.TransDataGoodsVo;
import com.biz.crm.trans.vo.TransDataStoreVo;
import com.biz.crm.trans.vo.TransDataVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.KmsOrgUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class KmsTransDataHelper {
    private static final Logger log = LoggerFactory.getLogger(KmsTransDataHelper.class);
    @Resource
    private KmsTenantryDirectStoreMapper kmsTenantryDirectStoreMapper;
    @Resource
    private KmsTenantryDirectProductMapper kmsTenantryDirectProductMapper;
    @Resource
    private KmsProductUnitMapper kmsProductUnitMapper;
    @Resource
    private MdmTerminalSupplyFeign mdmTerminalSupplyFeign;
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Resource
    private KmsSupplierMapper kmsSupplierMapper;

    public void transStore(TransDataVo transDataVo) {
        String key;
        KmsSupplierRespVo kmsSupplierRespVo;
        TransDataStoreVo heandVo = transDataVo.getStoreVos();
        ArrayList kaStoreCodes = Lists.newArrayList();
        ArrayList kaStoreNames = Lists.newArrayList();
        ArrayList bsDirectSystemIds = Lists.newArrayList();
        ArrayList supplierCodes = Lists.newArrayList();
        if (!StringUtils.isEmpty((Object)heandVo.getKaStoreCode())) {
            kaStoreCodes.add(heandVo.getKaStoreCode());
        }
        if (!StringUtils.isEmpty((Object)heandVo.getKaStoreName())) {
            kaStoreNames.add(heandVo.getKaStoreName());
        }
        bsDirectSystemIds.add(heandVo.getBsDirectSystemId());
        supplierCodes.add(heandVo.getSupplierCode());
        KmsTenantryDirectStoreReqVo directStoreReqVo = new KmsTenantryDirectStoreReqVo();
        directStoreReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        directStoreReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        directStoreReqVo.setKaStoreCodes((List)kaStoreCodes);
        directStoreReqVo.setKaStoreNames((List)kaStoreNames);
        directStoreReqVo.setBsDirectSystemIdList((List)bsDirectSystemIds);
        List<KmsTenantryDirectStoreRespVo> directStoreRespVos = this.kmsTenantryDirectStoreMapper.findStoreAndArea(directStoreReqVo);
        if (CollectionUtils.isEmpty(directStoreRespVos)) {
            heandVo.setOrderStatusMsg("|\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        ArrayList terminalCodes = Lists.newArrayList();
        List<KmsTenantryDirectStoreRespVo> kaStoreList = this.matchDirectStore(heandVo, directStoreRespVos);
        if (CollectionUtils.isEmpty(kaStoreList)) {
            heandVo.setOrderStatusMsg("|\u672a\u5339\u914d\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
        } else if (kaStoreList.size() > 1) {
            heandVo.setOrderStatusMsg("|\u5546\u8d85\u95e8\u5e97\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u5173\u7cfb");
        } else {
            KmsTenantryDirectStoreRespVo vo = kaStoreList.get(0);
            heandVo.setKaCode(vo.getBsDirectSystemCode());
            heandVo.setStoreCode(vo.getTerminalCode());
            heandVo.setStoreName(vo.getTerminalName());
            terminalCodes.add(vo.getTerminalCode());
            heandVo.setStoreRelatedId(vo.getId());
            heandVo.setTimeOfDay(vo.getTimeOfDay());
        }
        MdmTerminalSupplyVo supplyVo = new MdmTerminalSupplyVo();
        supplyVo.setTerminalCodeList((List)terminalCodes);
        List customerRespVos = (List)ApiResultUtil.objResult((Result)this.mdmTerminalSupplyFeign.findBySupply(supplyVo));
        if (CollectionUtils.isEmpty((Collection)customerRespVos)) {
            customerRespVos = Lists.newArrayList();
        }
        Map<String, List<MdmCustomerRespVo>> customerMap = customerRespVos.stream().collect(Collectors.groupingBy(MdmCustomerRespVo::getTerminalCode));
        ArrayList kmsTenantryDirectCustomerOrgEntities = CollectionUtils.isEmpty((Collection)bsDirectSystemIds) ? Lists.newArrayList() : this.kmsTenantryDirectCustomerOrgMapper.selectBatchIds(bsDirectSystemIds);
        ArrayList customerOrgIds = Lists.newArrayList();
        HashMap bsCustOrgMap = Maps.newHashMap();
        kmsTenantryDirectCustomerOrgEntities.forEach(bs -> {
            customerOrgIds.add(bs.getCustomerOrgId());
            bsCustOrgMap.put(bs.getId(), bs.getCustomerOrgCode());
        });
        CusOrgVo cusOrgVo = new CusOrgVo();
        cusOrgVo.setIds((List)customerOrgIds);
        List cusOrgVos = (List)ApiResultUtil.objResult((Result)this.mdmCusOrgFeign.findList(cusOrgVo));
        if (CollectionUtils.isEmpty((Collection)cusOrgVos)) {
            cusOrgVos = Lists.newArrayList();
        }
        Map cusOrgVoMap = cusOrgVos.stream().collect(Collectors.toMap(CusOrgVo::getCustomerOrgCode, Function.identity()));
        KmsSupplierReqVo supplierReqVo = new KmsSupplierReqVo();
        supplierReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        supplierReqVo.setSupplierCodes((List)supplierCodes);
        supplierReqVo.setBsDirectSystemIdList((List)bsDirectSystemIds);
        List<KmsSupplierRespVo> mapperList = this.kmsSupplierMapper.findList(supplierReqVo);
        Map supplierRespVoMap = mapperList.stream().collect(Collectors.toMap(s -> s.getBsDirectSystemId() + "-" + s.getSupplierCode(), Function.identity()));
        String bsDirectSystemId = heandVo.getBsDirectSystemId();
        String storeCode = heandVo.getStoreCode();
        List<Object> mdmCustomerList = customerMap.get(storeCode);
        if (!StringUtils.isEmpty((Object)heandVo.getSupplierCode()) && !ObjectUtils.isEmpty((Object)(kmsSupplierRespVo = (KmsSupplierRespVo)supplierRespVoMap.get(key = bsDirectSystemId + "-" + heandVo.getSupplierCode())))) {
            heandVo.setSoldToPartyCode(kmsSupplierRespVo.getSellPartyCode());
        }
        if (CollectionUtils.isEmpty(mdmCustomerList)) {
            heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|\u672a\u5339\u914d\u552e\u8fbe\u65b9\u4fe1\u606f\uff01");
        } else {
            if (!StringUtils.isEmpty((Object)heandVo.getSoldToPartyCode())) {
                mdmCustomerList = mdmCustomerList.stream().filter(e -> e.getCustomerCode().equals(heandVo.getSoldToPartyCode())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(mdmCustomerList)) {
                heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|\u672a\u5339\u914d\u552e\u8fbe\u65b9\u4fe1\u606f\uff01");
            } else if (mdmCustomerList.size() > 1) {
                heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|\u7ec8\u7aef\u95e8\u5e97[" + storeCode + "]\u627e\u5230\u591a\u4e2a\u552e\u8fbe\u65b9");
            } else {
                MdmCustomerRespVo mdmCustomerRespVo = mdmCustomerList.get(0);
                heandVo.setSoldToPartyCode(mdmCustomerRespVo.getCustomerCode());
                heandVo.setSoldToPartyName(mdmCustomerRespVo.getCustomerName());
                heandVo.setChannel(mdmCustomerRespVo.getChannel());
            }
        }
        String cusOrgCode = (String)bsCustOrgMap.get(bsDirectSystemId);
        CusOrgVo cusOrg = (CusOrgVo)cusOrgVoMap.get(cusOrgCode);
        if (!ObjectUtils.isEmpty((Object)cusOrg)) {
            heandVo.setCustomerOrgCode(cusOrg.getCustomerOrgCode());
            heandVo.setCustomerOrgType(cusOrg.getCustomerOrgType());
        } else {
            heandVo.setOrderStatusMsg(heandVo.getOrderStatusMsg() + "|\u672a\u627e\u5230\u5ba2\u6237\u7ec4\u7ec7");
        }
        transDataVo.setStoreVos(heandVo);
    }

    private List<KmsTenantryDirectStoreRespVo> matchDirectStore(TransDataStoreVo tstore, List<KmsTenantryDirectStoreRespVo> directStoreRespVos) {
        List<KmsTenantryDirectStoreRespVo> kaStoreList = null;
        String kaStoreCode = tstore.getKaStoreCode();
        String supplierCode = tstore.getSupplierCode();
        String kaName = tstore.getKaName();
        if (!StringUtils.isEmpty((Object)kaStoreCode)) {
            kaStoreList = directStoreRespVos.stream().filter(s -> s.getStoreCode().equals(kaStoreCode) && s.getBsDirectSystemName().equals(kaName)).collect(Collectors.toList());
            kaStoreList = this.areaFilter(tstore, kaStoreList);
        } else {
            String ksStoreName = tstore.getKaStoreName();
            kaStoreList = directStoreRespVos.stream().filter(s -> s.getStoreName().equals(ksStoreName) && s.getBsDirectSystemName().equals(kaName)).collect(Collectors.toList());
            kaStoreList = this.areaFilter(tstore, kaStoreList);
        }
        if (!StringUtils.isEmpty((Object)supplierCode) && !CollectionUtils.isEmpty(kaStoreList) && kaStoreList.size() > 1) {
            return kaStoreList.stream().filter(o -> supplierCode.equals(o.getExt1())).collect(Collectors.toList());
        }
        return kaStoreList;
    }

    private List<KmsTenantryDirectStoreRespVo> areaFilter(TransDataStoreVo tstore, List<KmsTenantryDirectStoreRespVo> kaStoreList) {
        String areaCode = tstore.getAreaCode();
        String areaName = tstore.getAreaName();
        if (!StringUtils.isEmpty((Object)areaCode)) {
            List<KmsTenantryDirectStoreRespVo> collect = kaStoreList.stream().filter(s -> areaCode.equals(s.getAreaCode())).collect(Collectors.toList());
            if (collect.size() > 1 && !StringUtils.isEmpty((Object)areaName)) {
                return collect.stream().filter(s -> areaName.equals(s.getAreaName())).collect(Collectors.toList());
            }
            return collect;
        }
        if (!StringUtils.isEmpty((Object)areaName)) {
            return kaStoreList.stream().filter(s -> areaName.equals(s.getAreaName())).collect(Collectors.toList());
        }
        return kaStoreList;
    }

    public void transGoods(TransDataVo transDataVo) {
        TransDataStoreVo heandVo = transDataVo.getStoreVos();
        List kaGoodsCodes = transDataVo.getGoodsVos().stream().map(TransDataGoodsVo::getKaGoodsCode).distinct().collect(Collectors.toList());
        KmsTenantryDirectProductReqVo params = new KmsTenantryDirectProductReqVo();
        params.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        params.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        params.setKaProductCodes(kaGoodsCodes);
        params.setBsDirectSystemId(heandVo.getBsDirectSystemId());
        List<KmsTenantryDirectProductRespVo> directProductRespVos = this.kmsTenantryDirectProductMapper.findList(params);
        if (CollectionUtils.isEmpty(directProductRespVos)) {
            transDataVo.getGoodsVos().forEach(o -> o.setOrderStatusMsg("|\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb"));
            return;
        }
        ArrayList productIds = new ArrayList();
        directProductRespVos.forEach(o -> {
            o.setCreateOrgCode(KmsOrgUtil.getCompanyOrgCode(o.getCreateOrgCode()));
            productIds.add(o.getId());
        });
        KmsProductUnitReqVo unitReqVo = new KmsProductUnitReqVo();
        unitReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        unitReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        unitReqVo.setOrderType(transDataVo.getOrderType());
        unitReqVo.setTenantryDirectProductIds(productIds);
        List<KmsProductUnitRespVo> unitRespVos = this.kmsProductUnitMapper.findList(unitReqVo);
        Map<String, List<KmsProductUnitRespVo>> unitMap = unitRespVos.stream().collect(Collectors.groupingBy(o -> o.getTenantryDirectProductId() + "_" + o.getKaUnitCode()));
        Map<String, List<KmsTenantryDirectProductRespVo>> kaStoreMap = directProductRespVos.stream().collect(Collectors.groupingBy(o -> o.getKaProductCode()));
        transDataVo.getGoodsVos().forEach(o -> {
            String orderNumber = o.getOrderNumber();
            String soldToPartyCode = heandVo.getSoldToPartyCode();
            String key = o.getKaGoodsCode();
            List productRespVos = (List)kaStoreMap.get(key);
            if (CollectionUtils.isEmpty((Collection)productRespVos)) {
                o.setOrderStatusMsg("|\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else if (CollectionUtils.isEmpty(productRespVos = productRespVos.stream().filter(s -> s.getSellPartyCode().equals(soldToPartyCode)).collect(Collectors.toList()))) {
                o.setOrderStatusMsg("|\u552e\u8fbe\u65b9[" + soldToPartyCode + "]\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else {
                String week = StringUtils.isEmpty((Object)o.getOrderDate()) ? "" : DateUtil.getWeek((String)o.getOrderDate());
                List weekFilterList = productRespVos.stream().filter(goods -> ObjectUtils.isEmpty((Object)goods.getTimeOfWeek()) || goods.getTimeOfWeek().toString().equals(week)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(weekFilterList)) {
                    o.setOrderStatusMsg("|\u672a\u5339\u914d\u5230\u4e0e\u4f01\u4e1a\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
                } else if (weekFilterList.size() > 1) {
                    o.setOrderStatusMsg("|\u4f01\u4e1a\u5546\u54c1\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u5173\u7cfb");
                } else {
                    KmsTenantryDirectProductRespVo vo = (KmsTenantryDirectProductRespVo)weekFilterList.get(0);
                    o.setGoodsCode(vo.getProductCode());
                    o.setGoodsName(vo.getProductName());
                    o.setGoodsRelatedId(vo.getId());
                    if (!StringUtils.isEmpty((Object)o.getCurUnit())) {
                        String unitKey = vo.getId() + "_" + o.getCurUnit();
                        List unitRespList = (List)unitMap.get(unitKey);
                        if (ObjectUtils.isEmpty((Object)unitRespList)) {
                            o.setOrderStatusMsg("|\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
                        } else if (unitRespList.size() > 1) {
                            o.setOrderStatusMsg("|\u5b58\u5728\u591a\u4e2a\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
                        } else {
                            KmsProductUnitRespVo unitRespVo = (KmsProductUnitRespVo)unitRespList.get(0);
                            BigDecimal numerator = ObjectUtils.isEmpty((Object)unitRespVo.getNumerator()) ? BigDecimal.ONE : unitRespVo.getNumerator();
                            o.setNumerator(numerator);
                            BigDecimal ratio = unitRespVo.getRatio();
                            o.setRatio(ratio);
                            o.setCurCompanyUnit(unitRespVo.getUnitCode());
                            String curUnitOrderQuantity = o.getCurUnitOrderQuantity();
                            if (StringUtils.isEmpty((Object)curUnitOrderQuantity)) {
                                o.setOrderStatusMsg("|\u5546\u8d85\u5355\u4f4d\u6570\u91cf\u9519\u8bef");
                            } else {
                                BigDecimal kaUnitQuantity = new BigDecimal(curUnitOrderQuantity);
                                BigDecimal companyUnitQuantity = kaUnitQuantity.multiply(numerator).divide(ratio, 6, 4);
                                o.setCurCompanyUnitOrderQuantity(companyUnitQuantity.toString());
                            }
                        }
                    } else {
                        o.setCurCompanyUnitOrderQuantity(o.getCurUnitOrderQuantity());
                    }
                }
            }
        });
    }
}

