/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.webservice.order.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.KmsUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@XmlRootElement
public class KmsSapOrderHeaderVo {
    private static final String SAP_KA_ORDER_PREFIX = "KMS-";
    @XmlElement(name="KUNNR")
    private String kunnr = "";
    @XmlElement(name="KUNWE")
    private String kunwe = "";
    @XmlElement(name="VKORG")
    private String vkorg = "";
    @XmlElement(name="VTWEG")
    private String vtweg = "";
    @XmlElement(name="SPART")
    private String spart = "01";
    @XmlElement(name="AUART")
    private String auart = "ZOR";
    @XmlElement(name="BSTKD")
    private String bstkd = "";
    @XmlElement(name="LFDAT")
    private String lfdat = "";
    @XmlElement(name="AUGRU")
    private String augru = "";
    @XmlElement(name="ZZ001")
    private String zz001 = "";
    @XmlElement(name="KOSTL")
    private String kostl = "";
    @XmlElement(name="AUDAT")
    private String audat = "";
    @XmlElement(name="CMPGN_EXTID")
    private String cmpgnExtid = "";
    @XmlElement(name="KUNWE2")
    private String kunwe2 = "";
    @XmlElement(name="IHREZ")
    private String ihrez = "";
    @XmlElement(name="SUBMI")
    private String submi = "";

    @XmlTransient
    public String getKunnr() {
        return this.kunnr;
    }

    public void setKunnr(String kunnr) {
        this.kunnr = kunnr;
    }

    @XmlTransient
    public String getKunwe() {
        return this.kunwe;
    }

    public void setKunwe(String kunwe) {
        this.kunwe = kunwe;
    }

    @XmlTransient
    public String getVkorg() {
        return this.vkorg;
    }

    public void setVkorg(String vkorg) {
        this.vkorg = vkorg;
    }

    @XmlTransient
    public String getVtweg() {
        return this.vtweg;
    }

    public void setVtweg(String vtweg) {
        this.vtweg = vtweg;
    }

    @XmlTransient
    public String getSpart() {
        return this.spart;
    }

    public void setSpart(String spart) {
        this.spart = spart;
    }

    @XmlTransient
    public String getAuart() {
        return this.auart;
    }

    public void setAuart(String auart) {
        this.auart = auart;
    }

    @XmlTransient
    public String getBstkd() {
        return this.bstkd;
    }

    public void setBstkd(String bstkd) {
        this.bstkd = bstkd;
    }

    @XmlTransient
    public String getLfdat() {
        return this.lfdat;
    }

    public void setLfdat(String lfdat) {
        this.lfdat = lfdat;
    }

    @XmlTransient
    public String getAugru() {
        return this.augru;
    }

    public void setAugru(String augru) {
        this.augru = augru;
    }

    @XmlTransient
    public String getZz001() {
        return this.zz001;
    }

    public void setZz001(String zz001) {
        this.zz001 = zz001;
    }

    @XmlTransient
    public String getKostl() {
        return this.kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    @XmlTransient
    public String getAudat() {
        return this.audat;
    }

    public void setAudat(String audat) {
        this.audat = audat;
    }

    @XmlTransient
    public String getCmpgnExtid() {
        return this.cmpgnExtid;
    }

    public void setCmpgnExtid(String cmpgnExtid) {
        this.cmpgnExtid = cmpgnExtid;
    }

    @XmlTransient
    public String getKunwe2() {
        return this.kunwe2;
    }

    public void setKunwe2(String kunwe2) {
        this.kunwe2 = kunwe2;
    }

    @XmlTransient
    public String getIhrez() {
        return this.ihrez;
    }

    public void setIhrez(String ihrez) {
        this.ihrez = ihrez;
    }

    @XmlTransient
    public String getSubmi() {
        return this.submi;
    }

    public void setSubmi(String submi) {
        this.submi = submi;
    }

    public KmsSapOrderHeaderVo() {
    }

    public KmsSapOrderHeaderVo(KmsOrderFormRespVo header) {
        AssertUtils.isNotEmpty((String)header.getSoldToPartyCode(), (String)"\u5ba2\u6237\u7f16\u53f7-\u552e\u8fbe\u65b9\u4e3a\u7a7a");
        header.setSoldToPartyCode(KmsUtils.addZero(header.getSoldToPartyCode(), 10));
        this.kunnr = header.getSoldToPartyCode();
        AssertUtils.isNotEmpty((String)header.getStoreCode(), (String)"\u9001\u8fbe\u65b9-\u4f01\u4e1a\u95e8\u5e97\u4e3a\u7a7a");
        header.setStoreCode(KmsUtils.addZero(header.getStoreCode(), 10));
        this.kunwe = header.getStoreCode();
        AssertUtils.isNotEmpty((String)header.getCustomerOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7-\u5ba2\u6237\u7ec4\u7ec7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)header.getCustomerOrgType(), (String)"\u9500\u552e\u7ec4\u7ec7-\u5ba2\u6237\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a");
        this.vkorg = header.getCustomerOrgCode();
        AssertUtils.isNotEmpty((String)header.getChannel(), (String)"\u5206\u9500\u6e20\u9053-\u5ba2\u6237\u6e20\u9053\u4e3a\u7a7a");
        this.vtweg = header.getChannel();
        this.spart = "01";
        this.auart = "ZOR";
        this.bstkd = SAP_KA_ORDER_PREFIX + header.getKaOrderNumber() + "-" + header.getStoreCode();
        Calendar cl = Calendar.getInstance();
        Map dateMap = DictUtil.dictMap((String)"kms_order_shipping_date");
        String day = (String)dateMap.get(header.getCustomerOrgCode());
        if (!StringUtils.isEmpty((Object)day)) {
            if (ObjectUtils.isEmpty((Object)header.getTimeOfDay())) {
                throw new BusinessException("\u8bf7\u914d\u7f6e\u76f4\u8425\u4f53\u7cfb\u8ba2\u5355\u63a8\u9001\u65f6\u95f4\u9608\u503c");
            }
            int dayInt = header.getTimeOfDay();
            cl.add(5, dayInt);
            String deliveryDate = DateUtil.format((Date)cl.getTime(), (String)"yyyyMMdd");
            header.setDeliveryDate(deliveryDate);
            this.lfdat = deliveryDate;
            this.audat = deliveryDate;
        } else {
            header.setDeliveryDate("");
            this.lfdat = "";
            this.audat = "";
        }
        this.augru = "";
        this.zz001 = "";
        this.kostl = "";
        this.cmpgnExtid = "";
        this.kunwe2 = "";
        this.ihrez = header.getIsExpedited();
        this.submi = "";
    }

    public static KmsSapOrderHeaderVoBuilder builder() {
        return new KmsSapOrderHeaderVoBuilder();
    }

    public static class KmsSapOrderHeaderVoBuilder {
        private KmsOrderFormRespVo header;

        KmsSapOrderHeaderVoBuilder() {
        }

        public KmsSapOrderHeaderVoBuilder header(KmsOrderFormRespVo header) {
            this.header = header;
            return this;
        }

        public KmsSapOrderHeaderVo build() {
            return new KmsSapOrderHeaderVo(this.header);
        }

        public String toString() {
            return "KmsSapOrderHeaderVo.KmsSapOrderHeaderVoBuilder(header=" + this.header + ")";
        }
    }
}

