/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.webservice.service.impl;

import com.biz.crm.eunm.kms.KmsEnum;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderFormReqVo;
import com.biz.crm.nebular.kms.orderform.req.KmsOrderGoodsReqVo;
import com.biz.crm.nebular.kms.orderform.req.WebServiceFindOrderReqVo;
import com.biz.crm.nebular.kms.orderform.resp.KmsOrderFormRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderItemRespVo;
import com.biz.crm.nebular.kms.orderform.resp.WebServiceFindOrderRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.orderform.mapper.KmsOrderFormMapper;
import com.biz.crm.orderform.mapper.KmsOrderGoodsMapper;
import com.biz.crm.supermarket.mapper.KmsTenantryDirectCustomerOrgMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.UserUtils;
import com.biz.crm.webservice.service.IKmsOrderWebService;
import com.bizunited.platform.common.vo.UuidVo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.soap.SOAPException;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@WebService(name="\u67e5\u8be2\u5546\u8d85\u8ba2\u8d27\u5355", serviceName="KmsOrderWebService", targetNamespace="http://www.biz-united.com.cn/", endpointInterface="com.biz.crm.webservice.service.IKmsOrderWebService")
@Component
public class KmsOrderWebServiceImpl
implements IKmsOrderWebService {
    private static final Logger log = LoggerFactory.getLogger(KmsOrderWebServiceImpl.class);
    @Resource
    private KmsTenantryDirectCustomerOrgMapper kmsTenantryDirectCustomerOrgMapper;
    @Resource
    private KmsOrderFormMapper kmsOrderFormMapper;
    @Resource
    private KmsOrderGoodsMapper kmsOrderGoodsMapper;

    @Override
    public List<WebServiceFindOrderRespVo> findKmsOrderFormList(WebServiceFindOrderReqVo webServiceFindOrderReqVo) {
        UserUtils.doTokenForNull();
        log.info("\u5916\u90e8\u7cfb\u7edf\u67e5\u8be2\u5546\u8d85\u8ba2\u8d27\u5355====");
        KmsOrderFormReqVo reqVo = this.paramCheck(webServiceFindOrderReqVo);
        List<WebServiceFindOrderRespVo> list = this.kmsOrderFormMapper.webServiceFindList(reqVo);
        if (!CollectionUtils.isEmpty(list)) {
            List<String> ids = list.stream().map(WebServiceFindOrderRespVo::getStoreRelatedId).distinct().collect(Collectors.toList());
            List<KmsOrderFormRespVo> nameList = this.kmsOrderFormMapper.findAreaName(ids);
            Map<String, List<KmsOrderFormRespVo>> areaNameMap = nameList.stream().collect(Collectors.groupingBy(UuidVo::getId));
            KmsOrderGoodsReqVo goodsReqVo = new KmsOrderGoodsReqVo();
            goodsReqVo.setOrderNumberList(list.stream().map(WebServiceFindOrderRespVo::getOrderNumber).collect(Collectors.toList()));
            List<WebServiceFindOrderItemRespVo> itemRespVos = this.kmsOrderGoodsMapper.webServiceFindList(goodsReqVo);
            Map<String, List<WebServiceFindOrderItemRespVo>> itemMap = itemRespVos.stream().collect(Collectors.groupingBy(WebServiceFindOrderItemRespVo::getOrderNumber));
            list.forEach(o -> {
                List vos = (List)areaNameMap.get(o.getStoreRelatedId());
                if (CollectionUtil.listNotEmptyNotSizeZero((List)vos)) {
                    o.setAreaName(((KmsOrderFormRespVo)vos.get(0)).getAreaName());
                }
                o.setGoodsVos((List)itemMap.get(o.getOrderNumber()));
            });
        }
        return list;
    }

    private KmsOrderFormReqVo paramCheck(WebServiceFindOrderReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getOwnedCompany())) {
            throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((Object)reqVo.getOrderDateStart()) || StringUtils.isEmpty((Object)reqVo.getOrderDateEnd())) {
            throw new Fault((Throwable)new SOAPException("\u5f00\u59cb\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        KmsOrderFormReqVo formReqVo = (KmsOrderFormReqVo)CrmBeanUtil.copy((Object)reqVo, KmsOrderFormReqVo.class);
        formReqVo.setOrderStatus(KmsEnum.OrderStatus.S400.getValue());
        try {
            List childrenOrgListIncludeSelf = OrgUtil.getChildrenOrgListIncludeSelf((String)reqVo.getOwnedCompany());
            if (CollectionUtils.isEmpty((Collection)childrenOrgListIncludeSelf)) {
                throw new Fault((Throwable)new SOAPException("\u516c\u53f8\u4ee3\u7801\u9519\u8bef\uff0c\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u4fe1\u606f"));
            }
            List orgCodes = childrenOrgListIncludeSelf.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            formReqVo.setOrgCodes(orgCodes);
        }
        catch (Exception e) {
            throw new Fault((Throwable)new SOAPException("\u67e5\u8be2\u516c\u53f8\u4ee3\u7801\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return formReqVo;
    }
}

