package com.biz.crm.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;

import java.util.Iterator;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/4 11:28
 **/
public class CrmJsonCompare {


    /**
     * json对比
     * @param jsonTemplateStr 模板json
     * @param oldJsonStr 改变之前的json
     * @param newJsonStr 改变之后的json
     */
    public static void compare(String jsonTemplateStr,String oldJsonStr,String newJsonStr){
        //json对比模板
        JSONObject jsonTemplate = JSON.parseObject(jsonTemplateStr);
        JSONObject oldJson = JSON.parseObject(oldJsonStr);
        JSONObject newJson = JSON.parseObject(newJsonStr);
        //循环模板对比
        Iterator iter = jsonTemplate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = entry.getKey().toString();
            String keyDescribe = entry.getValue().toString();
            Object oldValue = oldJson.get(key);
            Object newValue = newJson.get(key);
            System.out.println(compareFiled(keyDescribe,oldValue,newValue));
        }
    }

    /**
     * 比对自定义类型
     * @param jsonTemplateStr 模板json
     * @param oldJsonStr 改变之前的json
     * @param newJsonStr 改变之后的json
     */
    public static void compareOne2One(String jsonTemplateStr,String oldJsonStr,String newJsonStr){
        //json对比模板
        JSONObject jsonTemplate = JSON.parseObject(jsonTemplateStr);
        JSONObject oldJson = JSON.parseObject(oldJsonStr);
        JSONObject newJson = JSON.parseObject(newJsonStr);
        //循环模板对比
        Iterator iter = jsonTemplate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = entry.getKey().toString();
            String keyDescribe = entry.getValue().toString();
            Object oldValue = oldJson.get(key);
            Object newValue = newJson.get(key);
            System.out.println(compareFiled(keyDescribe,oldValue,newValue));
        }
    }


    /**
     * 比对字段值，并记录变化(基本类型)
     * 1、如果是包装类,先比对有无
     * 2、再比对值
     * @param keyDescribe 字段描述
     * @param oldValue 旧的字段值
     * @param newValue 新的字段值
     * @return 如果没有变化：返回null ；有变化 返回变化字符串
     */
    public static String compareFiled(String keyDescribe,Object oldValue,Object newValue){
        StringBuilder reStr = new StringBuilder();
        reStr.append("[").append(keyDescribe).append(":");
        //1
        if(!oldValue.getClass().isPrimitive()){
            if(null == oldValue && null != newValue){
                reStr.append("无 ---> ").append(newValue.toString());
                return reStr.append("]").toString();
            }
            if(null != oldValue && null == newValue){
                reStr.append(oldValue.toString()).append(" ---> 无");
            return reStr.append("]").toString();
        }
        if(null == oldValue && null == newValue){
            return null;
        }
        if(!oldValue.equals(newValue)){
            reStr.append(oldValue.toString()).append(" ---> ").append(newValue);
            return reStr.append("]").toString();
        }
    }else {//如果是基本类型
            if(oldValue != newValue){
                reStr.append(oldValue.toString()).append(" ---> ").append(newValue);
                return reStr.append("]").toString();
            }
        }
        return "";
    }



    public static void main(String[] args) {
        LogTest oldModel = LogTest.newInstance0();

        LogTest newModel = LogTest.newInstance1();;

        JSONObject jsonTemplate = LogTest.newInstanceModel();

        compare(
                JSON.toJSONString(jsonTemplate),
                JSON.toJSONString(oldModel),
                JSON.toJSONString(newModel)
                );
    }
}
