package com.biz.crm.log;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/10 15:04
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FiledMsg {

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段描述
     */
    private String desc;

    /**
     * 是否对比值
     */
    private boolean compare;

    /**
     * 字段分类，0：基础类型，1：1对1对象，2：1对多集合
     */
    private int hostType;

    /**
     * 当前字段模板对象
     */
    private JSONObject jsonTemplate;

    /**
     * 当前字段新旧对象关键的唯一值(one2Many专用)
     */
    private String onlyKey;

    /**
     * 当前字段新增对象或者删除对象的时候 唯一描述语句(指向模板字段的描述)（one2Many专属）
     */
    private String onlyFiled;
}
