package com.biz.crm.log;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.util.StringUtils;
import io.swagger.models.auth.In;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/11/24 16:56
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class LogTest extends OtherFiled{

    private Byte aByte;

    private byte bByte;

    /**
     * 一对一
     */
    private LogTest one2One;

    /**
     * 一对多
     */
    private List<LogTest> one2Many;

    public static JSONObject newInstanceModel(){
        JSONObject jsonTemplate = new JSONObject();
        jsonTemplate.put("aByte",createFiledMsg("大写Byte",true,"aByte",0));
        jsonTemplate.put("bByte",createFiledMsg("小写Byte",true,"bByte",0));

//-------------------------一对一--------------------------------
        jsonTemplate.put("one2One",
                createFiledMsgOne2("一对一",true,"one2One",1,null,null)
        );

//-------------------------一对多--------------------------------

        jsonTemplate.put("one2Many",
                createFiledMsgOne2("一对多",true,"one2Many",2,"id","id")
        );
        return jsonTemplate;
    }

    /**
     * 创建字段的msg
     */
    public static FiledMsg createFiledMsgOne2(String desc,boolean compare,String filedName,int hostType,String onlyKey,String onlyFiled){
        FiledMsg filedMsg = new FiledMsg();
        filedMsg.setDesc(desc);
        filedMsg.setCompare(compare);
        filedMsg.setFieldName(filedName);
        filedMsg.setHostType(hostType);
        filedMsg.setOnlyKey(onlyKey);
        filedMsg.setOnlyFiled(onlyFiled);

        JSONObject jsonTemplate = new JSONObject();
        FiledMsg filedMsg1 = new FiledMsg();
        filedMsg1.setDesc("大写Byte");
        filedMsg1.setCompare(true);
        filedMsg1.setFieldName("aByte");
        filedMsg1.setHostType(0);
        jsonTemplate.put("aByte",filedMsg1);

        FiledMsg filedMsg2 = new FiledMsg();
        filedMsg2.setDesc("小写Byte");
        filedMsg2.setCompare(true);
        filedMsg2.setFieldName("bByte");
        filedMsg2.setHostType(0);
        jsonTemplate.put("bByte",filedMsg2);

        if(!StringUtils.isEmpty(onlyKey)){
            FiledMsg filedMsg3 = new FiledMsg();
            filedMsg3.setDesc("唯一编码id");
            filedMsg3.setCompare(false);
            filedMsg3.setFieldName("id");
            filedMsg3.setHostType(0);
            jsonTemplate.put("id",filedMsg3);
        }

        filedMsg.setJsonTemplate(jsonTemplate);
        return filedMsg;
    }

    /**
     * 创建基本字段的msg
     * @param desc
     * @param compare
     * @param filedName
     * @param hostType
     * @return
     */
    public static FiledMsg createFiledMsg(String desc,boolean compare,String filedName,int hostType){
        FiledMsg filedMsg = new FiledMsg();
        filedMsg.setDesc(desc);
        filedMsg.setCompare(compare);
        filedMsg.setFieldName(filedName);
        filedMsg.setHostType(hostType);
        return filedMsg;
    }

    /**
     * 创建旧对象
     * @return
     */
    public static LogTest createOldInstance(){
        LogTest logTest = newInstance(new Byte("0"),new Byte("0"));
        logTest.setOne2One(newInstance(new Byte("0"),new Byte("0")));
        List<LogTest> list = new ArrayList<>();
        list.add(newInstance(new Byte("0"),new Byte("0")));
        list.add(newInstance(new Byte("0"),new Byte("0")));
        logTest.setOne2Many(list);
        return logTest;
    }

    /**
     * 创建新对象
     * @return
     */
    public static LogTest createNewInstance(){
        LogTest logTest = newInstance(new Byte("1"),new Byte("1"));
        logTest.setOne2One(newInstance(new Byte("1"),new Byte("1")));
        List<LogTest> list = new ArrayList<>();
        list.add(newInstance(new Byte("1"),new Byte("1")));
        list.add(newInstance(new Byte("1"),new Byte("1")));
        logTest.setOne2Many(list);
        return logTest;
    }

    /**
     * 创建对象
     * @return
     */
    public static LogTest newInstance(Byte aByte,byte bByte){
        LogTest logTest = new LogTest();
        logTest.setId(new Date().getTime() + "");
        logTest.setAByte(aByte);
        logTest.setBByte(bByte);
        return logTest;
    }
}
