package com.biz.crm.log.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.log.FiledMsg;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 一对多字段对比（暂时只支持conllction子类）
 * @Author: zhangyuzhu
 * @Date: 2020/12/15 14:43
 **/
public class One2ManyConpare {

    /**
     * 比对自定义类型
     * @param filedMsg 模板
     * @param oldJsonObjects 改变之前的json
     * @param newJsonObjects 改变之后的json
     */
    public static Object compare(FiledMsg filedMsg, List<JSONObject> oldJsonObjects, List<JSONObject> newJsonObjects){
        List<JSONObject> reList = new ArrayList<>();
        String onlyKey = filedMsg.getOnlyKey();
        JSONObject reObj = new JSONObject();
        if(StringUtils.isEmpty(onlyKey)){
            StringBuilder stb = new StringBuilder(filedMsg.getDesc()).append("未设置唯一key");
            reObj.put("解析失败",stb.toString());
        }
        //更新的对象
        List<Map<String,JSONObject>> updateList = new ArrayList<>();
        //先比对删除的
        for(JSONObject oleValue : oldJsonObjects){
            List<JSONObject> objects = newJsonObjects.stream().filter(newJsonObject -> newJsonObject.get(onlyKey).equals(oleValue.get(onlyKey))).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(objects)){
                StringBuilder stb = new StringBuilder();
                stb.append(filedMsg.getDesc()).append(":").append(filedMsg.getOnlyFiled())
                        .append(":").append(oleValue.get(onlyKey)).append("：被删除了");
                JSONObject json = new JSONObject();
                json.put(stb.toString(),oleValue);
                reList.add(json);
            }else {
                Map<String,JSONObject> map = new HashMap<>();
                map.put("old",oleValue);
                map.put("new",objects.get(0));
                updateList.add(map);
            }
        }
        //比对新创建的
        for(JSONObject newValue : newJsonObjects){
            List<JSONObject> objects = oldJsonObjects.stream().filter(oldJsonObject -> oldJsonObject.get(onlyKey).equals(newValue.get(onlyKey))).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(objects)){
                StringBuilder stb = new StringBuilder("新创建了:");
                stb.append(filedMsg.getDesc()).append(":")
                        .append(filedMsg.getOnlyFiled()).append(":").append(newValue.get(onlyKey));
                JSONObject json = new JSONObject();
                json.put(stb.toString(),newValue);
                reList.add(json);
            }
        }

        //循环模板对比更新的数据
        if(CollectionUtils.isEmpty(updateList)){
            return reList;
        }
        for(Map<String,JSONObject> map : updateList){
            if(filedMsg.getJsonTemplate() == null){
                if(StringUtils.isEmpty(onlyKey)){
                    StringBuilder stb = new StringBuilder(filedMsg.getDesc())
                            .append("未设置日志模板");
                    reObj.put("解析失败",stb.toString());
                }
            }
            JSONObject result = One2OneCompare.compare(filedMsg.getJsonTemplate(),
                    map.get("old"),
                    map.get("new")
            );
            if(!result.isEmpty()){
                reList.add(result);
            }
        }
        return reList;
    }
}
