package com.biz.crm.log.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.log.FiledMsg;
import org.springframework.util.StringUtils;

import java.util.Iterator;
import java.util.Map;

/**
 * @Description: 自定义引用类型对比
 * @Author: zhangyuzhu
 * @Date: 2020/12/15 14:42
 **/
public class One2OneCompare {

    /**
     * 比对自定义类型
     * @param jsonObject 模板json
     * @param oldJsonObject 改变之前的json
     * @param newJsonObject 改变之后的json
     */
    public static JSONObject compare(JSONObject jsonObject, JSONObject oldJsonObject, JSONObject newJsonObject){
        JSONObject reJson = new JSONObject();
        //循环模板对比
        Iterator iter = jsonObject.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = entry.getKey().toString();
            FiledMsg filedMsg = JSON.parseObject(JSON.toJSONString(entry.getValue()),FiledMsg.class);
            Object oldValue = oldJsonObject.get(key);
            Object newValue = newJsonObject.get(key);
            if(filedMsg.getHostType() == 0){
                reJson.put(filedMsg.getDesc(), BasicTypeCompare.compare(filedMsg.getDesc(),oldValue,newValue));
            }else if(filedMsg.getHostType() == 1){
                JSONObject json = One2OneCompare.compare(JSON.parseObject(JSON.toJSONString(filedMsg.getJsonTemplate())),
                        JSON.parseObject(JSON.toJSONString(oldValue)),
                        JSON.parseObject(JSON.toJSONString(newValue)));
                reJson.put(filedMsg.getDesc(),json);
            }else if(filedMsg.getHostType() == 2){
                reJson.put(filedMsg.getDesc(),
                            One2ManyConpare.compare(
                                    filedMsg,
                                    JSON.parseArray(JSON.toJSONString(oldValue),JSONObject.class),
                                    JSON.parseArray(JSON.toJSONString(newValue),JSONObject.class)
                            )
                        );
            }
        }
        return reJson;
    }
}
