package com.biz.crm.log;

import com.biz.crm.util.DateUtil;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 18:07
 **/
public class CrmLog {

    /**
     * 日志模板编码
     */
    private String templateCode;

    /**
     * 操作类型Code
     */
    private Integer operationType;

    /**
     * 记录唯一键（一般是id）
     */
    private String onlyKey;

    /**
     * 记录唯一描述（用于搜索）
     */
    private String onlyKeyDes;

    /**
     * 模块编码（取值字典）
     */
    private String modularCode;

    /**
     * 更新之前的对象
     */
    private Object oldObject;

    /**
     * 更新之后的对象
     */
    private Object newObject;

    /**
     * 操作人id
     */
    private String operationUserId;

    /**
     * 操作人姓名
     */
    private String operationUserName;

    /**
     * 操作时间
     */
    private String operationTime;

    public CrmLog(String templateCode,Integer operationType, String onlyKey, String modularCode, Object oldObject, Object newObject,String operationUserId,String operationUserName) {
        this.templateCode = templateCode;
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.modularCode = modularCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
        this.operationTime = DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN);
    }


    public CrmLog(Integer operationType, String onlyKey, String modularCode, Object oldObject, Object newObject,String operationUserId,String operationUserName) {
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.modularCode = modularCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
        this.operationTime = DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN);
    }

    public CrmLog(Integer operationType, String onlyKey, String onlyKeyDes, String modularCode, Object oldObject, Object newObject,String operationUserId,String operationUserName) {
        this.operationType = operationType;
        this.onlyKey = onlyKey;
        this.onlyKeyDes = onlyKeyDes;
        this.modularCode = modularCode;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.operationUserId = operationUserId;
        this.operationUserName = operationUserName;
        this.operationTime = DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN);
    }
}
