package com.biz.crm.log.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.log.entity.CrmLogEntity;
import com.biz.crm.log.repositories.CrmLogRepositories;
import com.biz.crm.log.service.CrmLogService;
import com.biz.crm.log.util.CrmLogContant;
import com.biz.crm.log.util.CrmLogUtil;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/17 17:19
 **/
@Service
public class CrmLogServiceImpl implements CrmLogService {

    @Autowired
    private CrmLogRepositories crmLogRepositories;

    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Autowired
    private RedissonUtil redissonUtil;


    @Override
    public void handle(CrmLogDto crmLogDto) {
        Integer operationType = crmLogDto.getOperationType();
        //1
        if(operationType.intValue() == LogEunm.OperationTypeEunm.ADD.getCode().intValue()){
            crmLogRepositories.saveAll(CrmLogUtil.vo2EntityForAdd(crmLogDto));
        }else if(operationType.intValue() == LogEunm.OperationTypeEunm.DEL.getCode().intValue()){
            crmLogRepositories.saveAll(CrmLogUtil.vo2EntityForDel(crmLogDto));
        }else {
            //TODO Compare.compare()
            Object resullt = new Object();
            crmLogRepositories.save(CrmLogUtil.vo2EntityForUpdate(crmLogDto,resullt));
        }
    }


    @Override
    public PageResult<CrmLogVo> list(CrmLogVo crmLogVo) {
        PageResult<CrmLogVo> pageResult = new PageResult<CrmLogVo>();
        pageResult.setCount(Long.parseLong("0"));
        pageResult.setData(new ArrayList<>());
        if(!EsUtil.indexExsit(elasticsearchTemplate,CrmLogEntity.class,redissonUtil)){
            return pageResult;
        }

        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if(null != crmLogVo.getOperationType()){
            boolQueryBuilder.must(QueryBuilders.termQuery("operationType.keyword",crmLogVo.getOperationType()));
        }
        if(!StringUtils.isEmpty(crmLogVo.getOnlyKey())){
            boolQueryBuilder.must(QueryBuilders.termQuery("getOnlyKey.keyword",crmLogVo.getOnlyKey()));
        }
        if(!StringUtils.isEmpty(crmLogVo.getOnlyKeyDes())){
            boolQueryBuilder.must(QueryBuilders.matchPhraseQuery("getOnlyKey",crmLogVo.getOnlyKeyDes()));
        }
        if(!StringUtils.isEmpty(crmLogVo.getModularCode())){
            boolQueryBuilder.must(QueryBuilders.termQuery("modularCode.keyword",crmLogVo.getModularCode()));
        }
        SearchQuery searchQuery = new NativeSearchQueryBuilder()
                .withIndices(CrmLogContant.ES_CRMLOG_INDEXNAME)//索引名
                .withQuery(boolQueryBuilder)//查询条件
                .withSort(SortBuilders.fieldSort("operationTimeNum").unmappedType("keyword").order(SortOrder.DESC))
                .withPageable(PageRequest.of(crmLogVo.getPageNum().intValue()-1,crmLogVo.getPageSize()))//分页参数
                .build();
        Page<CrmLogVo> scroll = elasticsearchTemplate.queryForPage(searchQuery,CrmLogVo.class);
        List<CrmLogVo> list = scroll.getContent();
        if(CollectionUtils.isEmpty(list)){
            return pageResult;
        }
        pageResult.setData(list);
        pageResult.setCount(scroll.getTotalElements());
        return pageResult;
    }
}
