package com.biz.crm.log;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:35
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Principal {

    /**
     * 名字
     */
    private String name;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 创建模板
     * @return
     */
    public static JSONObject createTemplate(){
        JSONObject jsonTemplate = new JSONObject();
        FiledMsg filedMsg1 = new FiledMsg();
        filedMsg1.setDesc("名字");
        filedMsg1.setCompare(true);
        filedMsg1.setFieldName("name");
        filedMsg1.setHostType(0);
        jsonTemplate.put("name",filedMsg1);

        FiledMsg filedMsg2 = new FiledMsg();
        filedMsg2.setDesc("年龄");
        filedMsg2.setCompare(true);
        filedMsg2.setFieldName("age");
        filedMsg2.setHostType(0);
        jsonTemplate.put("age",filedMsg2);

        return jsonTemplate;
    }


    public Principal(String name, Integer age) {
        this.name = name;
        this.age = age;
    }

    public static Principal createPrincipalOld(){
        return new Principal("张玉竹",28);
    }

    public static Principal createPrincipalNew(){
        return new Principal("张玉竹",30);
    }
}
