package com.biz.crm.log.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.log.service.CrmLogService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.log.CrmLogDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * @Description: crm日志处理消费者
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 20:13
 **/
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.CRMLOG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.CRMLOG + "${rocketmq.environment-variable}")
public class CrmLogMonitor extends AbstractRocketMQConsumer {

    @Resource
    private CrmLogService crmLogService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }

        CrmLogDto crmLogDto = JSON.parseObject(msg, CrmLogDto.class);
        if(null == crmLogDto){
            return "无效日志诉求!";
        }
        try {
            crmLogService.handle(crmLogDto);
        }catch (Exception e){
            StringBuilder stb = new StringBuilder("日志处理失败,日志:]");
            stb.append(msg);
            stb.append("],原因:").append(e);
            log.info(stb.toString());
        }
        return "操作成功";
    }
}
