package com.biz.crm.log.handle;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:34
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Grade {

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 等级
     */
    private Integer level;

    /**
     * 创建模板
     * @return
     */
    public static JSONObject createTemplate(){
        JSONObject jsonTemplate = new JSONObject();
        FiledMsg filedMsg1 = new FiledMsg();
        filedMsg1.setDesc("编码");
        filedMsg1.setCompare(true);
        filedMsg1.setFieldName("code");
        filedMsg1.setHostType(0);
        jsonTemplate.put("code",filedMsg1);

        FiledMsg filedMsg2 = new FiledMsg();
        filedMsg2.setDesc("名称");
        filedMsg2.setCompare(true);
        filedMsg2.setFieldName("name");
        filedMsg2.setHostType(0);
        jsonTemplate.put("name",filedMsg2);

        FiledMsg filedMsg3 = new FiledMsg();
        filedMsg3.setDesc("等级");
        filedMsg3.setCompare(true);
        filedMsg3.setFieldName("level");
        filedMsg3.setHostType(0);
        jsonTemplate.put("level",filedMsg3);

        return jsonTemplate;
    }

    public Grade(String code, String name, Integer level) {
        this.code = code;
        this.name = name;
        this.level = level;
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createOneOld(){
        return new Grade("one","一年级",1);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createOneNew(){
        return new Grade("one","一年级(新)",1);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createTwoOld(){
        return new Grade("two","二年级",2);
    }

    /**
     * 创建一年级
     * @return
     */
    public static Grade createTwoNew(){
        return new Grade("two","二年级(新)",2);
    }

    /**
     * 创建所有的年级
     * @return
     */
    public static List<Grade> createAllOld(){
        List<Grade> list = new ArrayList<>();
        list.add(createOneOld());
        list.add(createTwoOld());
        return list;
    }

    /**
     * 创建所有的年级
     * @return
     */
    public static List<Grade> createAllNew(){
        List<Grade> list = new ArrayList<>();
        list.add(createOneNew());
        list.add(createTwoNew());
        return list;
    }
}
