package com.biz.crm.log.handle;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:33
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class School {

    /**
     * 名称
     */
    private String name;

    /**
     * 地址
     */
    private String adress;

    /**
     * 校长
     */
    private Principal principal;

    /**
     * 年级
     */
    private List<Grade> grades;

    public static FiledMsg createTemplate(){
        JSONObject jsonTemplate = new JSONObject();
        FiledMsg filedMsg1 = new FiledMsg();
        filedMsg1.setDesc("名称");
        filedMsg1.setCompare(true);
        filedMsg1.setFieldName("name");
        filedMsg1.setHostType(0);
        jsonTemplate.put("name",filedMsg1);

        FiledMsg filedMsg2 = new FiledMsg();
        filedMsg2.setDesc("地址");
        filedMsg2.setCompare(true);
        filedMsg2.setFieldName("adress");
        filedMsg2.setHostType(0);
        jsonTemplate.put("adress",filedMsg2);

        FiledMsg filedMsg3 = new FiledMsg();
        filedMsg3.setDesc("校长");
        filedMsg3.setCompare(true);
        filedMsg3.setFieldName("principal");
        filedMsg3.setHostType(1);
        filedMsg3.setJsonTemplate(Principal.createTemplate());
        jsonTemplate.put("principal",filedMsg3);

        FiledMsg filedMsg4 = new FiledMsg();
        filedMsg4.setDesc("年级");
        filedMsg4.setCompare(true);
        filedMsg4.setFieldName("grades");
        filedMsg4.setHostType(2);
        filedMsg4.setJsonTemplate(Grade.createTemplate());
        filedMsg4.setOnlyKey("code");
        filedMsg4.setOnlyKeyName("编码");
        jsonTemplate.put("grades",filedMsg4);

        FiledMsg filedMsg = new FiledMsg();
        filedMsg.setJsonTemplate(jsonTemplate);
        filedMsg.setDesc("首层");
        filedMsg.setCompare(true);
        filedMsg.setFieldName("frist");
        filedMsg.setHostType(0);

        return filedMsg;
    }

    public School(String name, String adress) {
        this.name = name;
        this.adress = adress;
    }

    public static School createOld(){
        School school = new School("成都小学","成都市");
        school.setPrincipal(Principal.createPrincipalOld());
        school.setGrades(Grade.createAllOld());
        return school;
    }

    public static School createNew(){
        School school = new School("北京小学","北京市");
        school.setPrincipal(Principal.createPrincipalNew());
        school.setGrades(Grade.createAllNew());
        return school;
    }
}
