package com.biz.crm.log.handle.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.log.handle.FiledMsg;
import org.springframework.util.StringUtils;

import java.util.Iterator;
import java.util.Map;

/**
 * @Description: 自定义引用类型对比
 * @Author: zhangyuzhu
 * @Date: 2020/12/15 14:42
 **/
public class One2OneCompare {

    /**
     * 比对自定义类型
     * @param filedMsg 模板
     * @param oldJsonObject 改变之前的json
     * @param newJsonObject 改变之后的json
     */
    public static JSONObject compare(FiledMsg filedMsg, JSONObject oldJsonObject, JSONObject newJsonObject){
        if(filedMsg.getJsonTemplate() == null){
            return null;
        }
        JSONObject reJson = new JSONObject();
        //循环模板对比
        JSONObject jsonTemplate = filedMsg.getJsonTemplate();
        Iterator iter = jsonTemplate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            String key = entry.getKey().toString();
            FiledMsg subFiledMsg = JSON.toJavaObject((JSONObject) entry.getValue(),FiledMsg.class);
            Object oldValue = oldJsonObject.get(key);
            Object newValue = newJsonObject.get(key);
            if(subFiledMsg.getHostType() == 0){
                Object obj = BasicTypeCompare.compare(filedMsg.getDesc(),oldValue,newValue);
                if(!StringUtils.isEmpty(obj)){
                    reJson.put(subFiledMsg.getDesc(),obj);
                }
            }else if(subFiledMsg.getHostType() == 1){
                Object obj = One2OneCompare.compare(subFiledMsg,
                        (JSONObject)oldValue,
                        (JSONObject)newValue);
                if(!StringUtils.isEmpty(obj)){
                    reJson.put(subFiledMsg.getDesc(),obj);
                }
            }else if(subFiledMsg.getHostType() == 2){
                Object obj = One2ManyConpare.compare(
                        subFiledMsg,
                        JSON.parseArray(JSON.toJSONString(oldValue),JSONObject.class),
                        JSON.parseArray(JSON.toJSONString(newValue),JSONObject.class)
                );
                if(!StringUtils.isEmpty(obj)){
                    reJson.put(subFiledMsg.getDesc(),obj);
                }
            }
        }
        return reJson;
    }
}
