package com.biz.crm.log.template.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.log.template.entity.LogFieldEntity;
import com.biz.crm.log.template.entity.LogTemplateEntity;
import com.biz.crm.log.template.service.LogTemplateService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 日志模板管理端接口管理类
 * @Author: chenrong
 * @Date: 2020/12/9 17:48
 */
@Api(value = "管理端-日志模板管理端接口管理类", tags = "管理端-日志模板管理端接口管理类")
@RestController
@RequestMapping(value = "/m/log/")
public class LogTemplatemController {

  @Resource
  private LogTemplateService logTemplateService;

  @CrmLog
  @ApiOperation(value = "根据类型查询字段")
  @GetMapping(value = "findFieldsByType")
  public Result<Map<String, LogFieldEntity>> findFieldsByType(@RequestParam("type") String type) {
    Map<String, LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldsByType(type);
    return Result.ok(logFieldEntities);
  }

  @CrmLog
  @ApiOperation(value = "根据类型查询字段列表")
  @GetMapping(value = "findFieldListByType")
  public Result<List<LogFieldEntity>> findFieldListByType(@RequestParam("type") String type) {
    List<LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldListByType(type);
    return Result.ok(logFieldEntities);
  }

  @CrmLog
  @ApiOperation(value = "根据类型和模板编码查询字段")
  @GetMapping(value = "findFieldsByTypeAndCode")
  public Result<Map<String, LogFieldEntity>> findFieldsByTypeAndCode(@RequestParam("type") String type, @RequestParam("templateCode") String templateCode
  , @RequestParam("tree") @ApiParam("层级，如：repFeePool.repFeePoolItems.repFeePoolDetails") String tree) {
    Map<String, LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldsByTypeAndCode(type, templateCode, tree);
    return Result.ok(logFieldEntities);
  }

  @CrmLog
  @ApiOperation(value = "根据类型和模板编码查询字段列表")
  @GetMapping(value = "findFieldListByTypeAndCode")
  public Result<List<LogFieldEntity>> findFieldListByTypeAndCode(@RequestParam("type") String type, @RequestParam("templateCode") String templateCode
          , @RequestParam(value = "tree", required = false) @ApiParam("层级，如：repFeePool.repFeePoolItems.repFeePoolDetails") String tree) {
    List<LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldListByTypeAndCode(type, templateCode, tree);
    return Result.ok(logFieldEntities);
  }

  @CrmLog
  @ApiOperation(value = "创建模板")
  @PostMapping(value = "create")
  public Result create(@RequestBody LogTemplateEntity logTemplateVo) {
    this.logTemplateService.create(logTemplateVo);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "修改模板")
  @PostMapping(value = "update")
  public Result update(@RequestBody LogTemplateEntity logTemplateVo) {
    this.logTemplateService.update(logTemplateVo);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation("读取模板")
  @PostMapping(value = "read")
  public Result<LogTemplateEntity> read(@RequestParam("templateCode") String templateCode) {
    LogTemplateEntity logTemplateVo = this.logTemplateService.read(templateCode);
    return Result.ok(logTemplateVo);
  }

  @CrmLog
  @ApiOperation("分页条件查询日志模板")
  @PostMapping("findPageByConditions")
  public Result<PageResult<LogTemplateEntity>> findPageByConditions(@RequestBody LogTemplateEntity req) {
    PageResult<LogTemplateEntity> pageResult = this.logTemplateService.findPageByConditions(req);
    return Result.ok(pageResult);
  }

  @CrmLog
  @ApiOperation("启用禁用日志模板")
  @GetMapping("enable")
  public Result enable(@RequestParam(name = "templateCode") String templateCode, @RequestParam(name = "status") boolean status) {
    this.logTemplateService.enable(templateCode, status);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation("根据编码删除日志模板")
  @DeleteMapping("deleteByCode")
  public Result deleteByCode(@RequestParam(name = "templateCode") String templateCode) {
    this.logTemplateService.deleteByCode(templateCode);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "根据id批量删除")
  @PostMapping(value = "delByIds")
  public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
    logTemplateService.delByIds(ids);
    return Result.ok();
  }


}
