package com.biz.crm.log.template.entity;

import com.biz.crm.log.utils.CrmLogContants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;

import java.io.Serializable;
import java.util.Map;

/**
 * 日志模板对象
 * @Author: chenrong
 * @Date: 2020/12/9 15:15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Document(indexName= CrmLogContants.ES_LOG_TEMPLATE_INDEX, type=CrmLogContants.ES_LOG_TEMPLATE_TYPE,createIndex = false)
public class LogTemplateEntity implements Serializable {

  /**
   * 业务模块编码(菜单编码)
   */
  private String menuCode;

  /**
   * 业务模型名称(可同菜单名称)
   */
  private String businessName;

  /**
   * 模板类全路径
   */
  private String type;

  /**
   * 字段列表
   */
  private Map<String, LogFieldEntity> fieldMap;

  /**
   * 是否启用（字典）
   */
  private Integer enableFlag;
}
