package com.biz.crm.log.handle.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.log.handle.FiledMsg;
import com.biz.crm.log.handle.School;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @Description: 对比主入口
 * @Author: zhangyuzhu
 * @Date: 2020/12/4 11:28
 **/
public class Compare {


    /**
     * json对比
     * @param jsonTemplateStr 模板json
     * @param oldJsonStr 改变之前的json
     * @param newJsonStr 改变之后的json
     */
    public static Object compare(String jsonTemplateStr,String oldJsonStr,String newJsonStr){
        JSONObject exJsonObject = new JSONObject();
        if(StringUtils.isEmpty(jsonTemplateStr)){
            exJsonObject.put("解析失败:","日志模板未配置");
            return exJsonObject;
        }
        if(oldJsonStr.startsWith("[")){
            return compareCollection(
                    jsonTemplateStr,
                    JSONArray.parseArray(oldJsonStr,JSONObject.class),
                    JSONArray.parseArray(newJsonStr,JSONObject.class)
            );
        }else {
            return compareObjectNotBasicAndCollection(
                    jsonTemplateStr,
                    JSON.parseObject(oldJsonStr),
                    JSON.parseObject(newJsonStr)
                    );
        }
    }


    /**
     * 对比普通对象（不包括集合 和 基本类型）
     * @param jsonTemplateStr
     * @param oldObject
     * @param newObject
     * @return
     */
    public static JSONObject compareObjectNotBasicAndCollection(String jsonTemplateStr,JSONObject oldObject,JSONObject newObject){
        return One2OneCompare.compare(JSON.parseObject(jsonTemplateStr,FiledMsg.class),oldObject,newObject);
    }


    /**
     * 对比列表
     * @param jsonTemplateStr
     * @param oldList
     * @param newList
     * @return
     */
    public static Object compareCollection(String jsonTemplateStr,List<JSONObject> oldList,List<JSONObject> newList){
        FiledMsg filedMsg = JSON.parseObject(jsonTemplateStr,FiledMsg.class);
        return One2ManyConpare.compare(filedMsg,oldList,newList);
    }


    public static void main(String[] args) {
        Object obj = compareOne2One();
        System.out.println(JSON.toJSONString(obj));
    }


    public static Object compareOne2One(){
        return compare(
                JSON.toJSONString(School.createTemplate()),
                JSON.toJSONString(School.createOld()),
                JSON.toJSONString(School.createNew())
        );
    }

}
