package com.biz.crm.log.template.entity;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * 日志规则字段对象
 * @Author: chenrong
 * @Date: 2020/12/9 15:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class LogFieldEntity implements Serializable {

  /**
   * 字段名称
   */
  private String fieldName;

  /**
   * 字段描述
   */
  private String desc;

  /**
   * 是否对比值(字典)
   */
  private Integer compareFalg;

  /**
   * 字段类型（全路径）
   */
  private String type;

  /**
   * 字段分类(字典crmlog_host_type)
   */
  private Integer hostType;

  /**
   * 字段分类名称
   */
  private String hostTypeName;

  /**
   * 下级字段对象的map形式(非基本类型才有)
   */
  private Map<String, LogFieldEntity> children;

  /**
   * 当前字段模板对象(children的map形式的Json对象)
   */
  private JSONObject jsonTemplate;

  /**
   * 当前字段新旧对象关键的唯一值(one2Many专用)
   */
  private String onlyKey;

  /**
   * 当前字段新增对象或者删除对象的时候 唯一描述语句(指向模板字段的描述)（one2Many专属）
   */
  private String onlyKeyName;
}
