package com.biz.crm.log.template.service;



import com.biz.crm.common.PageResult;
import com.biz.crm.log.template.entity.LogFieldEntity;
import com.biz.crm.log.template.entity.LogTemplateEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 日志规则逻辑处理类
 * @Author: chenrong
 * @Date: 2020/12/9 15:13
 */
public interface LogTemplateService {

  /**
   * 根据类型查询字段列表
   * @param type
   * @return
   */
  Map<String, LogFieldEntity> findFieldsByType(String type);

  /**
   * 根据类型和日志模板编码查询字段列表
   * @param type
   * @param templateCode
   * @param tree
   * @return
   */
  Map<String, LogFieldEntity> findFieldsByTypeAndCode(String type, String templateCode, String tree);

  /**
   * 创建模板
   * @param vo
   */
  void create(LogTemplateEntity vo);

  /**
   * 修改模板
   * @param vo
   */
  void update(LogTemplateEntity vo);

  /**
   * 读取模板
   * @param templateCode
   * @return
   */
  LogTemplateEntity read(String templateCode);

  /**
   * 分页条件查询日志模板
   * @param req
   * @return
   */
  PageResult<LogTemplateEntity> findPageByConditions(LogTemplateEntity req);

  /**
   * 启用禁用
   * @param templateCode
   * @param status
   */
  void enable(String templateCode, boolean status);

  /**
   * 根据模板编码删除记录
   * @param templateCode
   */
  void deleteByCode(String templateCode);

  /**
   * 根据类型查询字段列表
   * @param type
   * @return
   */
  List<LogFieldEntity> findFieldListByType(String type);

  /**
   * 根据类型和模板编码查询字段列表
   * @param type
   * @param templateCode
   * @param tree
   * @return
   */
  List<LogFieldEntity> findFieldListByTypeAndCode(String type, String templateCode, String tree);

  /**
   * 根据id批量删除
   * @param ids
   */
  void delByIds(ArrayList<String> ids);

  /**
   * 读取模板（json string）
   * @param templateCode
   * @return
   */
  String readJson(String templateCode);
}
