package com.biz.crm.log.entity;

import com.biz.crm.log.util.CrmLogContant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;

import java.io.Serializable;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/17 15:46
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Document(indexName= CrmLogContant.ES_CRMLOG_INDEXNAME, type=CrmLogContant.ES_CRMLOG_TYPE,createIndex = false)
public class CrmLogEntity implements Serializable {

    /**
     * id,为es设置
     */
    private String id;

    /**
     * 操作类型Code
     */
    private Integer operationType;

    /**
     * 记录唯一键（一般是id）(一般只有update操作才有)
     */
    private String onlyKey;

    /**
     * 记录唯一描述（用于搜索,新增或者删除用）
     */
    private String onlyKeyDes;

    /**
     * 模块编码（取值字典）
     */
    private String modularCode;

    /**
     * 更新之前的对象(update和del专属)
     */
    private Object oldObject;

    /**
     * 更新之后的对象(update和add专属)
     */
    private Object newObject;

    /**
     * 更新之后对比的结果(update专属)
     */
    private Object compareResult;

    /**
     * 操作人id
     */
    private String operationUserId;

    /**
     * 操作人姓名
     */
    private String operationUserName;

    /**
     * 操作时间
     */
    private String operationTime;

    /**
     * 操作时间毫秒数
     */
    private Long operationTimeNum;
}
