package com.biz.crm.log.template.util;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.log.template.entity.LogFieldEntity;
import com.biz.crm.log.template.entity.LogTemplateEntity;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/19 14:57
 **/
public class LogTemplateUtil {

    /**
     * 模型转换
     * @param vo
     * @return
     */
    public static LogTemplateEntity voToEntityForAdd(LogTemplateVo vo){
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(UUIDGenerator.generate());
        entity.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        entity.setFieldMapStr(JSON.toJSONString(voToEntityForField(vo.getFieldList(),true)));
        return entity;
    }


    /**
     * 模型转换
     * @param vo
     * @return
     */
    public static LogTemplateEntity voToEntityForUpdate(LogTemplateVo vo,LogTemplateEntity logTemplateEntity){
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(logTemplateEntity.getId());
        entity.setEnableFlag(logTemplateEntity.getEnableFlag());
        entity.setMenuCode(logTemplateEntity.getMenuCode());
        entity.setFieldMapStr(JSON.toJSONString(voToEntityForField(vo.getFieldList(),true)));
        return entity;
    }

    /**
     * 组装字段
     * @param filedVods
     * @param subFlag 是否管下级字段
     * @return
     */
    public static Map<String,LogFieldEntity> voToEntityForField(List<LogFieldVo> filedVods,boolean subFlag){
        if(CollectionUtils.isEmpty(filedVods)){
            return new HashMap<>();
        }
        Map<String,LogFieldEntity> reMap = new HashMap<>();
        for(LogFieldVo fieldVo : filedVods){
            LogFieldEntity fieldEntity = new LogFieldEntity();
            BeanUtils.copyProperties(fieldVo,fieldEntity);
            //sub的的map和json
            if(subFlag){
                Map<String,LogFieldEntity> subMap = voToEntityForField(fieldVo.getChildrenList(),false);
                fieldEntity.setJsonTemplate(JSONObject.parseObject(JSON.toJSONString(subMap)));
            }
            reMap.put(fieldVo.getFieldName(),fieldEntity);
        }
        return reMap;
    }

    /**
     * 判断类型
     * @param claszz
     * @return
     */
    public static Integer judgeClass(Class claszz) {
        if(claszz == Integer.class
        || claszz == Double.class
        || claszz == Long.class
        || claszz == Float.class
        || claszz == Character.class
        || claszz == Byte.class
        || claszz == String.class
        || claszz == BigDecimal.class
        ){
            return LogEunm.HostTypeEunm.BASIC.getCode();
        }else if(claszz.isAssignableFrom(Collection.class)){
            return LogEunm.HostTypeEunm.ONE2MANY.getCode();
        }else {
            return LogEunm.HostTypeEunm.ONE2ONE.getCode();
        }
    }


    /**
     * 组装字段vo
     * @param fields
     * @return
     */
    public static List<LogFieldVo> packageFiledVo(List<Field> fields){
        if(CollectionUtils.isEmpty(fields)){
            return new ArrayList<>();
        }
        List<LogFieldVo> reList = new ArrayList<>(fields.size());
        for(Field field : fields){
            LogFieldVo vo = new LogFieldVo();
            vo.setFieldName(field.getName());
            vo.setDesc("");
            vo.setCompareFalg(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            vo.setType(field.getType().getName());
            if(field.getType().isPrimitive()){
                vo.setHostType(LogEunm.HostTypeEunm.BASIC.getCode());
            }else {
                vo.setHostType(judgeClass(field.getType()));
            }
            reList.add(vo);
        }
        return reList;
    }


    /**
     * 获取类所有字段，包括所有父类
     * @param clazz
     * @return
     */
    public static List<Field> getFields(Class clazz) {
        List<Field> fields = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}
