/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.log.handle.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.log.handle.service.CrmLogService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.log.CrmLogDto;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="CRMLOG", consumerGroup="CRMLOG${rocketmq.environment-variable}")
public class CrmLogMonitor
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(CrmLogMonitor.class);
    @Resource
    private CrmLogService crmLogService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        CrmLogDto crmLogDto = (CrmLogDto)JSON.parseObject((String)msg, CrmLogDto.class);
        if (null == crmLogDto) {
            return "\u65e0\u6548\u65e5\u5fd7\u8bc9\u6c42!";
        }
        try {
            this.crmLogService.handle(crmLogDto);
        }
        catch (Exception e) {
            StringBuilder stb = new StringBuilder("\u65e5\u5fd7\u5904\u7406\u5931\u8d25,\u65e5\u5fd7:]");
            stb.append(msg);
            stb.append("],\u539f\u56e0:").append(e);
            log.info(stb.toString());
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }
}

