package com.biz.crm.crmlog.handle.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.service.CrmLogService;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-日志", tags = "管理端-日志")
@RestController
@RequestMapping("/m/crmlog")
public class CrmLogmController {

    @Resource
    private CrmLogService crmLogService;

    @ApiOperation(value = "分页搜索日志")
    @PostMapping(value = "list")
    public Result<PageResult<CrmLogVo>> list(@RequestBody CrmLogVo crmLogVo) {
        return Result.ok(crmLogService.list(crmLogVo));
    }
}
