package com.biz.crm.crmlog.handle.tool;

/**
 * @Description: 基本类型字段对比
 * @Author: zhangyuzhu
 * @Date: 2020/12/15 14:41
 **/
public class BasicTypeCompare {

    /**
     * 比对字段值，并记录变化(基本类型)
     * 1、如果是包装类,先比对有无
     * 2、再比对值
     * @param keyDescribe 字段描述
     * @param oldValue 旧的字段值
     * @param newValue 新的字段值
     * @return 如果没有变化：返回null ；有变化 返回变化字符串
     */
    public static String compare(String keyDescribe,Object oldValue,Object newValue){
        StringBuilder reStr = new StringBuilder();
        reStr.append("【");
        //1
        if(!oldValue.getClass().isPrimitive()){
            if(null == oldValue && null != newValue){
                reStr.append("无 ---> ").append(newValue.toString());
                return reStr.append("】").toString();
            }
            if(null != oldValue && null == newValue){
                reStr.append(oldValue.toString()).append(" ---> 无");
                return reStr.append("】").toString();
            }
            if(null == oldValue && null == newValue){
                return null;
            }
            if(!oldValue.equals(newValue)){
                reStr.append(oldValue.toString()).append(" ---> ").append(newValue);
                return reStr.append("】").toString();
            }
        }else {//如果是基本类型
            if(oldValue != newValue){
                reStr.append(oldValue.toString()).append(" ---> ").append(newValue);
                return reStr.append("】").toString();
            }
        }
        return "";
    }
}
