package com.biz.crm.crmlog.template.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.crmlog.template.service.LogTemplateService;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 日志模板管理端接口管理类
 * @Author: chenrong
 * @Date: 2020/12/9 17:48
 */
@Api(value = "管理端-日志模板管理端接口管理类", tags = "管理端-日志模板管理端接口管理类")
@RestController
@RequestMapping(value = "/m/log/")
public class LogTemplatemController {

  @Resource
  private LogTemplateService logTemplateService;


  @CrmLog
  @ApiOperation(value = "新增模板")
  @PostMapping(value = "add")
  public Result<Object> add(@RequestBody LogTemplateVo logTemplateVo) {
    logTemplateService.add(logTemplateVo);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation("分页查询模板")
  @PostMapping("listWithPage")
  public Result<PageResult<LogTemplateVo>> listWithPage(@RequestBody LogTemplateVo vo) {
    PageResult<LogTemplateVo> pageResult = logTemplateService.listWithPage(vo);
    return Result.ok(pageResult);
  }

  @CrmLog
  @ApiOperation(value = "根据id查询模板")
  @GetMapping(value = "findById/{id}")
  public Result<LogTemplateVo> findById(@PathVariable("id") String id){
    return Result.ok(logTemplateService.findById(id));
  }

  @CrmLog
  @ApiOperation(value = "修改模板")
  @PostMapping(value = "update")
  public Result<Object> update(@RequestBody LogTemplateVo logTemplateVo) {
    logTemplateService.update(logTemplateVo);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation("禁用日志模板")
  @GetMapping("enable/{id}")
  public Result<Object> enable(@PathVariable(name = "id") String id) {
    logTemplateService.updateEnable(id, YesNoEnum.YesNoCodeNumberEnum.NO);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation("启用日志模板")
  @GetMapping("able/{id}")
  public Result<Object> able(@PathVariable(name = "id") String id) {
    logTemplateService.updateEnable(id, YesNoEnum.YesNoCodeNumberEnum.YES);
    return Result.ok();
  }

  @ApiOperation(value = "根据id批量删除")
  @PostMapping(value = "delByIds")
  public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
    logTemplateService.delByIds(ids);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "根据类型查询字段(类全路径)")
  @PostMapping(value = "findFieldsByType")
  public Result<List<LogFieldVo>> findFieldsByType(@RequestBody LogTemplateVo logTemplateVo) {
    return Result.ok(logTemplateService.findFieldsByType(logTemplateVo.getTypeClassPath()));
  }


}
