package com.biz.crm.crmlog.handle.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.crmlog.handle.School;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import org.springframework.util.CollectionUtils;

/**
 * @Description: 对比主入口
 * @Author: zhangyuzhu
 * @Date: 2020/12/4 11:28
 **/
public class Compare {


    /**
     * json对比
     * @param template 模板
     * @param oldJsonStr 改变之前的json
     * @param newJsonStr 改变之后的json
     */
    public static Object compare(LogTemplateEntity template, String oldJsonStr, String newJsonStr){
        if(null == template || CollectionUtils.isEmpty(template.getFieldMap())){
            throw new BusinessException("日志模板不存在,或者没配置比对字段！");
        }
        return compareObjectNotBasicAndCollection(
                template,
                JSON.parseObject(oldJsonStr),
                JSON.parseObject(newJsonStr)
                );
    }


    /**
     * 对比普通对象（不包括集合 和 基本类型）
     * @param template
     * @param oldObject
     * @param newObject
     * @return
     */
    public static JSONObject compareObjectNotBasicAndCollection(LogTemplateEntity template,JSONObject oldObject,JSONObject newObject){
        return One2OneCompare.compare(template.getFieldMap(),oldObject,newObject);
    }


    public static void main(String[] args) {
        Object obj = compareOne2One();
        System.out.println(JSON.toJSONString(obj));
    }


    public static Object compareOne2One(){
        return compare(
                School.createTemplate(),
                JSON.toJSONString(School.createOld()),
                JSON.toJSONString(School.createNew())
        );
    }

}
