package com.biz.crm.crmlog.handle.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 16:55
 **/
@Component
public class CrmLogSendUtil {

    @Autowired
    private RocketMQProducer rocketMQProducer;

    /**
     * 修改发送处理日志
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param oldObject 更新之前的对象
     * @param newObject 更新之后的对象
     */
    public void sendForUpdate(String menuCode, String onlykey,String onlyKeyDes, Object oldObject,Object newObject){
        if(null == oldObject || null == newObject){
            throw new BusinessException("更新日志比对前/后值为空！");
        }
        if(StringUtils.isEmpty(menuCode)){
            throw new BusinessException("日志模板编码为空！");
        }
        if(StringUtils.isEmpty(onlykey)){
            throw new BusinessException("日志唯一标记为空！");
        }
        if(oldObject instanceof Collection || newObject instanceof Collection){
            throw new BusinessException("暂不支持集合日志对比！");
        }
        UserRedis userRedis = UserUtils.getUser();
        CrmLogDto crmLogDto = CrmLogDto.newInstance()
                .operationType(LogEunm.OperationTypeEunm.UPDATE.getCode())
                .only(onlykey,onlyKeyDes)
                .menuCode(menuCode)
                .opObj(oldObject,newObject)
                .operationUser(userRedis.getUsername(),userRedis.getRealname())
                .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
        msg.setMsgBody(JSON.toJSONString(crmLogDto));
        rocketMQProducer.convertAndSend(msg);
    }

    /**
     *
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param obj 删除的对象
     */
    public void sendForDel(String menuCode, String onlykey,String onlyKeyDes,Object obj){
        if(StringUtils.isEmpty(menuCode)){
            throw new BusinessException("日志模板编码为空！");
        }
        UserRedis userRedis = UserUtils.getUser();
        CrmLogDto crmLogDto = CrmLogDto.newInstance()
                .operationType(LogEunm.OperationTypeEunm.DEL.getCode())
                .only(onlykey,onlyKeyDes)
                .menuCode(menuCode)
                .opObj(obj,null)
                .operationUser(userRedis.getUsername(),userRedis.getRealname())
                .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
        msg.setMsgBody(JSON.toJSONString(crmLogDto));
        rocketMQProducer.convertAndSend(msg);
    }


    /**
     *
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param obj 新增的对象
     */
    public void sendForAdd(String menuCode, String onlykey,String onlyKeyDes,Object obj){
        if(StringUtils.isEmpty(menuCode)){
            throw new BusinessException("日志模板编码为空！");
        }
        UserRedis userRedis = UserUtils.getUser();
        CrmLogDto crmLogDto = CrmLogDto.newInstance()
                .operationType(LogEunm.OperationTypeEunm.ADD.getCode())
                .only(onlykey,onlyKeyDes)
                .menuCode(menuCode)
                .opObj(null,obj)
                .operationUser(userRedis.getUsername(),userRedis.getRealname())
                .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
        msg.setMsgBody(JSON.toJSONString(crmLogDto));
        rocketMQProducer.convertAndSend(msg);
    }
}
