package com.biz.crm.crmlog.handle;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:33
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class School {

    /**
     * 名称
     */
    private String name;

    /**
     * 地址
     */
    private String adress;

    /**
     * 校长
     */
    private Principal principal;

    /**
     * 年级
     */
    private List<Grade> grades;

    public static LogTemplateEntity createTemplate(){
        Map<String, LogFieldEntity> reMap = new HashMap<>();

        LogFieldEntity logFieldEntity1 = new LogFieldEntity();
        logFieldEntity1.setFieldName("name");
        logFieldEntity1.setDesc("名称");
        logFieldEntity1.setCompareFalg(1);
        logFieldEntity1.setType("java.lang.String");
        logFieldEntity1.setHostType(0);
        reMap.put("name",logFieldEntity1);

        LogFieldEntity logFieldEntity2 = new LogFieldEntity();
        logFieldEntity2.setFieldName("adress");
        logFieldEntity2.setDesc("地址");
        logFieldEntity2.setCompareFalg(1);
        logFieldEntity2.setType("java.lang.String");
        logFieldEntity2.setHostType(0);
        reMap.put("adress",logFieldEntity2);

        LogFieldEntity logFieldEntity3 = new LogFieldEntity();
        logFieldEntity3.setFieldName("principal");
        logFieldEntity3.setDesc("校长");
        logFieldEntity3.setCompareFalg(1);
        logFieldEntity3.setType("com.biz.crm.log.handle.Principal");
        logFieldEntity3.setHostType(1);
        logFieldEntity3.setChildren(Principal.createTemplate());
        reMap.put("principal",logFieldEntity3);

        LogFieldEntity logFieldEntity4 = new LogFieldEntity();
        logFieldEntity4.setFieldName("grades");
        logFieldEntity4.setDesc("年级");
        logFieldEntity4.setCompareFalg(1);
        logFieldEntity4.setType("com.biz.crm.log.handle.Grade");
        logFieldEntity4.setHostType(2);
        logFieldEntity4.setChildren(Grade.createTemplate());
        logFieldEntity4.setOnlyKey("name");
        logFieldEntity4.setOnlyKeyName("年纪");
        reMap.put("grades",logFieldEntity4);

        LogTemplateEntity template = new LogTemplateEntity();
        template.setId("111");
        template.setMenuCode("asasaa");
        template.setBusinessName("学校(测试)");
        template.setTypeClassPath("com.biz.crm.log.handle.School");
        template.setFieldMap(reMap);
        template.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        return template;
    }

    public School(String name, String adress) {
        this.name = name;
        this.adress = adress;
    }

    public static School createOld(){
        School school = new School("成都小学","成都市");
        school.setPrincipal(Principal.createPrincipalOld());
        school.setGrades(Grade.createAllOld());
        return school;
    }

    public static School createNew(){
        School school = new School("北京小学","北京市");
        school.setPrincipal(Principal.createPrincipalNew());
        school.setGrades(Grade.createAllNew());
        return school;
    }
}
