package com.biz.crm.crmlog.template.service;


import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 日志规则逻辑处理类
 * @Author: chenrong
 * @Date: 2020/12/9 15:13
 */
public interface LogTemplateService {

  /**
   * 创建模板
   * @param vo
   */
  void add(LogTemplateVo vo);

  /**
   * 分页条件查询日志模板
   * @param vo
   * @return
   */
  PageResult<LogTemplateVo> listWithPage(LogTemplateVo vo);

  /**
   * 根据模板id查询字段列表
   * @param id
   * @return
   */
  LogTemplateVo findById(String id);

  /**
   * 修改模板
   * @param vo
   */
  void update(LogTemplateVo vo);

  /**
   * 更新启禁用按钮
   * @param id
   * @param yesNoCodeNumberEnum
   */
  void updateEnable(String id, YesNoEnum.YesNoCodeNumberEnum yesNoCodeNumberEnum);


  /**
   * 根据id批量删除
   * @param ids
   */
  void delByIds(ArrayList<String> ids);

  /**
   * 根据类全路径获取所有的字段
   * @param type
   * @return 如果没有则返回空集合
   */
  List<LogFieldVo> findFieldsByType(String type);

  /**
   * 根据code获取模板类型
   * @param code
   * @return
   */
  LogTemplateEntity findTemplateByCode(String code);
}
