package com.biz.crm.crmlog.handle;

import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 11:35
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Principal {

    /**
     * 名字
     */
    private String name;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 创建模板
     * @return
     */
    public static Map<String, LogFieldEntity> createTemplate(){
        Map<String, LogFieldEntity> reMap = new HashMap<>();

        LogFieldEntity logFieldEntity1 = new LogFieldEntity();
        logFieldEntity1.setFieldName("name");
        logFieldEntity1.setDesc("名字");
        logFieldEntity1.setCompareFalg(1);
        logFieldEntity1.setType("java.lang.String");
        logFieldEntity1.setHostType(0);
        reMap.put("name",logFieldEntity1);

        LogFieldEntity logFieldEntity2 = new LogFieldEntity();
        logFieldEntity2.setFieldName("age");
        logFieldEntity2.setDesc("年龄");
        logFieldEntity2.setCompareFalg(1);
        logFieldEntity2.setType("java.lang.Integer");
        logFieldEntity2.setHostType(0);
        reMap.put("age",logFieldEntity2);

        return reMap;
    }


    public Principal(String name, Integer age) {
        this.name = name;
        this.age = age;
    }

    public static Principal createPrincipalOld(){
        return new Principal("张玉竹",28);
    }

    public static Principal createPrincipalNew(){
        return new Principal("张玉竹",30);
    }
}
