package com.biz.crm.crmlog.handle.util;

import com.biz.crm.mq.RocketMQProducer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/16 16:55
 **/
@Slf4j
@Component
public class CrmLogSendUtil {

    @Autowired
    private RocketMQProducer rocketMQProducer;

    /**
     * 修改发送处理日志
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param oldObject 更新之前的对象
     * @param newObject 更新之后的对象
     */
    public void sendForUpdate(String menuCode, String onlykey,String onlyKeyDes, Object oldObject,Object newObject){
//        try{
//            if(null == oldObject || null == newObject){
//                log.error("更新日志比对前/后值为空！");
//                return;
//            }
//            if(StringUtils.isEmpty(menuCode)){
//                log.error("日志模板编码为空！");
//                return;
//            }
//            if(StringUtils.isEmpty(onlykey)){
//                log.error("日志唯一标记为空！");
//                return;
//            }
//            if(oldObject instanceof Collection || newObject instanceof Collection){
//                log.error("暂不支持集合日志对比！");
//                return;
//            }
//            UserRedis userRedis = UserUtils.getUser();
//            CrmLogDto crmLogDto = CrmLogDto.newInstance()
//                    .operationType(LogEunm.OperationTypeEunm.UPDATE.getCode())
//                    .only(onlykey,onlyKeyDes)
//                    .menuCode(menuCode)
//                    .opObj(oldObject,newObject)
//                    .operationUser(userRedis.getUsername(),userRedis.getRealname())
//                    .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
//            RocketMQMessageBody msg = new RocketMQMessageBody();
//            msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
//            msg.setMsgBody(JSON.toJSONString(crmLogDto));
//            rocketMQProducer.convertAndSend(msg);
//        }catch (Exception e){
//            log.error(new StringBuilder("日志发送失败").append(e.getMessage()).toString());
//        }
    }

    /**
     *
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param obj 删除的对象
     */
    public void sendForDel(String menuCode, String onlykey,String onlyKeyDes,Object obj){
//        try{
//            if(StringUtils.isEmpty(menuCode)){
//                log.error("日志模板编码为空！");
//                return;
//            }
//            UserRedis userRedis = UserUtils.getUser();
//            CrmLogDto crmLogDto = CrmLogDto.newInstance()
//                    .operationType(LogEunm.OperationTypeEunm.DEL.getCode())
//                    .only(onlykey,onlyKeyDes)
//                    .menuCode(menuCode)
//                    .opObj(obj,null)
//                    .operationUser(userRedis.getUsername(),userRedis.getRealname())
//                    .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
//            RocketMQMessageBody msg = new RocketMQMessageBody();
//            msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
//            msg.setMsgBody(JSON.toJSONString(crmLogDto));
//            rocketMQProducer.convertAndSend(msg);
//        }catch (Exception e){
//            log.error(new StringBuilder("日志发送失败").append(e.getMessage()).toString());
//        }
    }


    /**
     *
     * @param menuCode 日志模板编码(等同于菜单编码)
     * @param onlykey 记录唯一key（一般是id 同一个模板的操作 onlykey请保持一致）
     * @param onlyKeyDes 记录唯一的描述（用于日志页面搜索）
     * @param obj 新增的对象
     */
    public void sendForAdd(String menuCode, String onlykey,String onlyKeyDes,Object obj){
//        try{
//            if(StringUtils.isEmpty(menuCode)){
//                log.error("日志模板编码为空！");
//                return;
//            }
//            UserRedis userRedis = UserUtils.getUser();
//            CrmLogDto crmLogDto = CrmLogDto.newInstance()
//                    .operationType(LogEunm.OperationTypeEunm.ADD.getCode())
//                    .only(onlykey,onlyKeyDes)
//                    .menuCode(menuCode)
//                    .opObj(null,obj)
//                    .operationUser(userRedis.getUsername(),userRedis.getRealname())
//                    .operationTime(DateUtil.format(DateUtil.getDate(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
//            RocketMQMessageBody msg = new RocketMQMessageBody();
//            msg.setTag(RocketMQConstant.CRM_MQ_TAG.CRMLOG);
//            msg.setMsgBody(JSON.toJSONString(crmLogDto));
//            rocketMQProducer.convertAndSend(msg);
//        }catch (Exception e){
//            log.error(new StringBuilder("日志发送失败").append(e.getMessage()).toString());
//        }
    }
}
