/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlog.handle.util;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.biz.crm.crmlog.handle.entity.CrmLogEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.mdm.logtemplate.CrmLogDto;
import com.biz.crm.nebular.mdm.logtemplate.LogFieldVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CrmLogUtil {
    public static List<CrmLogEntity> vo2EntityForAdd(CrmLogDto crmLogDto) {
        ArrayList<CrmLogEntity> reList = null;
        Object newObject = crmLogDto.getNewObject();
        if (newObject instanceof Collection) {
            List newObjects = (List)newObject;
            reList = new ArrayList(newObjects.size());
            for (Object object : newObjects) {
                CrmLogEntity entity = CrmLogUtil.newCommonFieldInstance(crmLogDto);
                entity.setNewObject(JSON.toJSONString(object));
                reList.add(entity);
            }
            return reList;
        }
        reList = new ArrayList<CrmLogEntity>(1);
        CrmLogEntity entity = CrmLogUtil.newCommonFieldInstance(crmLogDto);
        entity.setNewObject(JSON.toJSONString((Object)newObject));
        reList.add(entity);
        return reList;
    }

    public static List<CrmLogEntity> vo2EntityForDel(CrmLogDto crmLogDto) {
        ArrayList<CrmLogEntity> reList = null;
        Object oldObject = crmLogDto.getOldObject();
        if (oldObject instanceof Collection) {
            List oldObjects = (List)oldObject;
            reList = new ArrayList(oldObjects.size());
            for (Object object : oldObjects) {
                CrmLogEntity entity = CrmLogUtil.newCommonFieldInstance(crmLogDto);
                entity.setOldObject(JSON.toJSONString(object));
                reList.add(entity);
            }
            return reList;
        }
        reList = new ArrayList<CrmLogEntity>(1);
        CrmLogEntity entity = CrmLogUtil.newCommonFieldInstance(crmLogDto);
        entity.setOldObject(JSON.toJSONString((Object)oldObject));
        reList.add(entity);
        return reList;
    }

    public static CrmLogEntity vo2EntityForUpdate(CrmLogDto crmLogDto, Object result) {
        CrmLogEntity entity = CrmLogUtil.newCommonFieldInstance(crmLogDto);
        entity.setOldObject(JSON.toJSONString((Object)crmLogDto.getOldObject()));
        entity.setNewObject(JSON.toJSONString((Object)crmLogDto.getNewObject()));
        entity.setCompareResult(JSON.toJSONString((Object)result));
        return entity;
    }

    public static CrmLogEntity newCommonFieldInstance(CrmLogDto crmLogDto) {
        CrmLogEntity entity = new CrmLogEntity();
        entity.setId(UUIDGenerator.generate());
        entity.setOnlyKey(crmLogDto.getOnlyKey());
        entity.setOperationType(crmLogDto.getOperationType());
        entity.setOnlyKeyDes(crmLogDto.getOnlyKeyDes());
        entity.setMenuCode(crmLogDto.getMenuCode());
        entity.setOperationUserId(crmLogDto.getOperationUserId());
        entity.setOperationUserName(crmLogDto.getOperationUserName());
        entity.setOperationTime(crmLogDto.getOperationTime());
        entity.setOperationTimeNum(DateUtil.str2Date((String)entity.getOperationTime(), (SimpleDateFormat)DateUtil.datetimeFormat).getTime());
        return entity;
    }

    public static List<LogFieldVo> packageFiledVo(List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return new ArrayList<LogFieldVo>();
        }
        ArrayList<LogFieldVo> reList = new ArrayList<LogFieldVo>(fields.size());
        for (Field field : fields) {
            LogFieldVo vo = new LogFieldVo();
            vo.setFieldName(field.getName());
            vo.setDesc("");
            vo.setCompareFalg(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if (field.getType().isPrimitive()) {
                vo.setHostType(LogEunm.HostTypeEunm.BASIC.getCode());
            } else {
                vo.setHostType(CrmLogUtil.judgeClass(field.getType()));
            }
            if (vo.getHostType().intValue() == LogEunm.HostTypeEunm.ONE2MANY.getCode().intValue()) {
                Type genericType = field.getGenericType();
                ParameterizedType type = (ParameterizedType)genericType;
                Class clazz = (Class)type.getActualTypeArguments()[0];
                vo.setType(clazz.getName());
            } else {
                vo.setType(field.getType().getName());
            }
            reList.add(vo);
        }
        return reList;
    }

    public static Integer judgeClass(Class claszz) {
        if (claszz == Integer.class || claszz == Double.class || claszz == Long.class || claszz == Float.class || claszz == Character.class || claszz == Byte.class || claszz == String.class || claszz == BigDecimal.class) {
            return LogEunm.HostTypeEunm.BASIC.getCode();
        }
        if (Collection.class.isAssignableFrom(claszz)) {
            return LogEunm.HostTypeEunm.ONE2MANY.getCode();
        }
        return LogEunm.HostTypeEunm.ONE2ONE.getCode();
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList fields = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

