/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlog.handle.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.entity.CrmLogEntity;
import com.biz.crm.crmlog.handle.repositories.CrmLogRepositories;
import com.biz.crm.crmlog.handle.service.CrmLogService;
import com.biz.crm.crmlog.handle.tool.Compare;
import com.biz.crm.crmlog.handle.util.CrmLogUtil;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.crmlog.template.service.LogTemplateService;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"crmLogServiceExpandImpl"})
@Service(value="crmLogService")
public class CrmLogServiceImpl
implements CrmLogService {
    @Autowired
    private CrmLogRepositories crmLogRepositories;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private LogTemplateService logTemplateService;

    @Override
    public void handle(CrmLogDto crmLogDto) {
        Integer operationType = crmLogDto.getOperationType();
        if (operationType.intValue() == LogEunm.OperationTypeEunm.ADD.getCode().intValue()) {
            this.crmLogRepositories.saveAll(CrmLogUtil.vo2EntityForAdd(crmLogDto));
        } else if (operationType.intValue() == LogEunm.OperationTypeEunm.DEL.getCode().intValue()) {
            this.crmLogRepositories.saveAll(CrmLogUtil.vo2EntityForDel(crmLogDto));
        } else {
            if (StringUtils.isEmpty((Object)crmLogDto.getMenuCode())) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u65e5\u5fd7\u6a21\u677f\u7f16\u7801\uff01");
            }
            LogTemplateEntity template = this.logTemplateService.findTemplateByCode(crmLogDto.getMenuCode());
            if (null == template || CollectionUtils.isEmpty(template.getFieldMap())) {
                throw new BusinessException("\u65e5\u5fd7\u6a21\u677f\u4e0d\u5b58\u5728,\u6216\u8005\u6ca1\u914d\u7f6e\u6bd4\u5bf9\u5b57\u6bb5\uff01");
            }
            Object resullt = Compare.compare(template, JSON.toJSONString((Object)crmLogDto.getOldObject()), JSON.toJSONString((Object)crmLogDto.getNewObject()));
            this.crmLogRepositories.save(CrmLogUtil.vo2EntityForUpdate(crmLogDto, resullt));
        }
    }

    @Override
    public PageResult<CrmLogVo> list(CrmLogVo crmLogVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, CrmLogEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (null != crmLogVo.getOperationType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"operationType.keyword", (Object)crmLogVo.getOperationType()));
        }
        if (!StringUtils.isEmpty((Object)crmLogVo.getOnlyKey())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"onlyKey.keyword", (String)crmLogVo.getOnlyKey()));
        }
        if (!StringUtils.isEmpty((Object)crmLogVo.getOnlyKeyDes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"onlyKeyDes", (Object)crmLogVo.getOnlyKeyDes()));
        }
        if (!StringUtils.isEmpty((Object)crmLogVo.getMenuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"menuCode.keyword", (String)crmLogVo.getMenuCode()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"crmlogindex"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"operationTimeNum").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)PageRequest.of((int)(crmLogVo.getPageNum() - 1), (int)crmLogVo.getPageSize())).build()), CrmLogEntity.class)).getContent()))) {
            return pageResult;
        }
        pageResult.setData(CrmBeanUtil.copyList((List)list, CrmLogVo.class));
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }
}

