/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.crmlog.handle.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.log.CrmLogDto;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CrmLogSendUtil {
    private static final Logger log = LoggerFactory.getLogger(CrmLogSendUtil.class);
    @Autowired
    private RocketMQProducer rocketMQProducer;

    public void sendForUpdate(String menuCode, String onlykey, String onlyKeyDes, Object oldObject, Object newObject) {
        try {
            if (null == oldObject || null == newObject) {
                log.error("\u66f4\u65b0\u65e5\u5fd7\u6bd4\u5bf9\u524d/\u540e\u503c\u4e3a\u7a7a\uff01");
                return;
            }
            if (StringUtils.isEmpty((Object)menuCode)) {
                log.error("\u65e5\u5fd7\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff01");
                return;
            }
            if (StringUtils.isEmpty((Object)onlykey)) {
                log.error("\u65e5\u5fd7\u552f\u4e00\u6807\u8bb0\u4e3a\u7a7a\uff01");
                return;
            }
            if (oldObject instanceof Collection || newObject instanceof Collection) {
                log.error("\u6682\u4e0d\u652f\u6301\u96c6\u5408\u65e5\u5fd7\u5bf9\u6bd4\uff01");
                return;
            }
            UserRedis userRedis = UserUtils.getUser();
            CrmLogDto crmLogDto = CrmLogDto.newInstance().operationType(LogEunm.OperationTypeEunm.UPDATE.getCode()).only(onlykey, onlyKeyDes).menuCode(menuCode).opObj(oldObject, newObject).operationUser(userRedis.getUsername(), userRedis.getRealname()).operationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            RocketMQMessageBody msg = new RocketMQMessageBody();
            msg.setTag("CRMLOG");
            msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
            this.rocketMQProducer.convertAndSend(msg);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u53d1\u9001\u5931\u8d25" + e.getMessage());
        }
    }

    public void sendForDel(String menuCode, String onlykey, String onlyKeyDes, Object obj) {
        try {
            if (StringUtils.isEmpty((Object)menuCode)) {
                log.error("\u65e5\u5fd7\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff01");
                return;
            }
            UserRedis userRedis = UserUtils.getUser();
            CrmLogDto crmLogDto = CrmLogDto.newInstance().operationType(LogEunm.OperationTypeEunm.DEL.getCode()).only(onlykey, onlyKeyDes).menuCode(menuCode).opObj(obj, null).operationUser(userRedis.getUsername(), userRedis.getRealname()).operationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            RocketMQMessageBody msg = new RocketMQMessageBody();
            msg.setTag("CRMLOG");
            msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
            this.rocketMQProducer.convertAndSend(msg);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u53d1\u9001\u5931\u8d25" + e.getMessage());
        }
    }

    public void sendForAdd(String menuCode, String onlykey, String onlyKeyDes, Object obj) {
        try {
            if (StringUtils.isEmpty((Object)menuCode)) {
                log.error("\u65e5\u5fd7\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a\uff01");
                return;
            }
            UserRedis userRedis = UserUtils.getUser();
            CrmLogDto crmLogDto = CrmLogDto.newInstance().operationType(LogEunm.OperationTypeEunm.ADD.getCode()).only(onlykey, onlyKeyDes).menuCode(menuCode).opObj(null, obj).operationUser(userRedis.getUsername(), userRedis.getRealname()).operationTime(DateUtil.format((Date)DateUtil.getDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            RocketMQMessageBody msg = new RocketMQMessageBody();
            msg.setTag("CRMLOG");
            msg.setMsgBody(JSON.toJSONString((Object)crmLogDto));
            this.rocketMQProducer.convertAndSend(msg);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u53d1\u9001\u5931\u8d25" + e.getMessage());
        }
    }
}

