package com.biz.crm.crmlog.handle.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.service.CrmLogService;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "api-日志", tags = "api-日志")
@RestController
@RequestMapping("/api/crmlog")
public class CrmLogApiController {

    @Resource
    private CrmLogService crmLogService;

    @ApiOperation(value = "分页搜索日志(没有指定menuCode返回空集合)")
    @PostMapping(value = "listNonMenuCodeReEmpty")
    public Result<PageResult<CrmLogVo>> listNonMenuCodeReEmpty(@RequestBody CrmLogVo crmLogVo) {
        if(StringUtils.isEmpty(crmLogVo.getMenuCode())){
            PageResult<CrmLogVo> pageResult = new PageResult<CrmLogVo>();
            pageResult.setCount(Long.parseLong("0"));
            pageResult.setData(new ArrayList<>());
            return Result.ok(pageResult);
        }
        return Result.ok(crmLogService.list(crmLogVo));
    }


    @ApiOperation(value = "分页搜索日志(没有指定menuCode查询所有模块日志)")
    @PostMapping(value = "listNonMenuCodeReAll")
    public Result<PageResult<CrmLogVo>> listNonMenuCodeReAll(@RequestBody CrmLogVo crmLogVo) {
        return Result.ok(crmLogService.list(crmLogVo));
    }
}
