package com.biz.crm.crmlog.template.util;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.crmlog.template.entity.LogFieldEntity;
import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.log.LogEunm;
import com.biz.crm.nebular.log.template.LogFieldVo;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/19 14:57
 **/
public class LogTemplateUtil {

    /**
     * 保存redis中key的前缀,或者临时值
     */
    public static final String redisPrefix = "crmLog";

    /**
     * 组装redis key的值
     * @param code
     * @return
     */
    public static String packageRedisKey(String code){
        return new StringBuilder(redisPrefix).append(code).toString();
    }

    /**
     * 模型转换
     * @param vo
     * @return
     */
    public static LogTemplateEntity voToEntityForAdd(LogTemplateVo vo){
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(UUIDGenerator.generate());
        entity.setEnableFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        entity.setFieldListStr(JSON.toJSONString(voToEntityForField(vo.getFieldList(),true)));
        return entity;
    }


    /**
     * 模型转换
     * @param vo
     * @return
     */
    public static LogTemplateEntity voToEntityForUpdate(LogTemplateVo vo,LogTemplateEntity logTemplateEntity){
        LogTemplateEntity entity = new LogTemplateEntity();
        BeanUtils.copyProperties(vo,entity);
        entity.setId(logTemplateEntity.getId());
        entity.setFieldListStr(JSON.toJSONString(voToEntityForField(vo.getFieldList(),true)));
        return entity;
    }

    /**
     * 组装字段
     * @param filedVods
     * @param subFlag 是否管下级字段
     * @return
     */
    public static List<LogFieldEntity> voToEntityForField(List<LogFieldVo> filedVods, boolean subFlag){
        if(CollectionUtils.isEmpty(filedVods)){
            return new ArrayList<>();
        }
        List<LogFieldEntity> reList = new ArrayList<>();
        for(LogFieldVo fieldVo : filedVods){
            LogFieldEntity fieldEntity = new LogFieldEntity();
            BeanUtils.copyProperties(fieldVo,fieldEntity);
            //sub的的map和json
            if(subFlag){
                List<LogFieldEntity> subList = voToEntityForField(fieldVo.getChildrenList(),false);
                fieldEntity.setChildrenListStr(JSON.toJSONString(subList));
            }
            reList.add(fieldEntity);
        }
        return reList;
    }

    /**
     * 判断类型
     * @param claszz
     * @return
     */
    public static Integer judgeClass(Class claszz) {
        if(claszz == Integer.class
        || claszz == Double.class
        || claszz == Long.class
        || claszz == Float.class
        || claszz == Character.class
        || claszz == Byte.class
        || claszz == String.class
        || claszz == BigDecimal.class
        ){
            return LogEunm.HostTypeEunm.BASIC.getCode();
        }else if(Collection.class.isAssignableFrom(claszz)){
            return LogEunm.HostTypeEunm.ONE2MANY.getCode();
        }else {
            return LogEunm.HostTypeEunm.ONE2ONE.getCode();
        }
    }


    /**
     * 组装字段vo
     * @param fields
     * @return
     */
    public static List<LogFieldVo> packageFiledVo(List<Field> fields){
        if(CollectionUtils.isEmpty(fields)){
            return new ArrayList<>();
        }
        List<LogFieldVo> reList = new ArrayList<>(fields.size());
        for(Field field : fields){
            LogFieldVo vo = new LogFieldVo();
            vo.setFieldName(field.getName());
            vo.setDesc("");
            vo.setCompareFalg(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if(field.getType().isPrimitive()){
                vo.setHostType(LogEunm.HostTypeEunm.BASIC.getCode());
            }else {
                vo.setHostType(judgeClass(field.getType()));
            }
            if(vo.getHostType().intValue() == LogEunm.HostTypeEunm.ONE2MANY.getCode().intValue()){
                Type genericType = field.getGenericType();
                ParameterizedType type = (ParameterizedType) genericType;
                Class clazz = (Class) type.getActualTypeArguments()[0];
                vo.setType(clazz.getName());
            }else {
                vo.setType(field.getType().getName());
            }
            reList.add(vo);
        }
        return reList;
    }


    /**
     * 获取类所有字段，包括所有父类
     * @param clazz
     * @return
     */
    public static List<Field> getFields(Class clazz) {
        List<Field> fields = Lists.newArrayList();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }


    /**
     * 查询的时候转换对象
     * @param logTemplateEntity
     * @param fieldMap
     * @return
     */
    public static LogTemplateEntity transformEntity(LogTemplateEntity logTemplateEntity,Map<String, LogFieldEntity> fieldMap){
        if(StringUtils.isEmpty(logTemplateEntity.getFieldListStr())){
            return null;
        }
        List<LogFieldEntity> fieldList = JSONArray.parseArray(logTemplateEntity.getFieldListStr(),LogFieldEntity.class);
        if(org.springframework.util.CollectionUtils.isEmpty(fieldList)){
            return null;
        }
        for(LogFieldEntity logFieldEntity : fieldList){
            fieldMap.put(logFieldEntity.getFieldName(),logFieldEntity);
            //子字段map
            Map<String, LogFieldEntity> childrenMap = new HashMap<>();
            logFieldEntity.setChildren(childrenMap);
            if(StringUtils.isEmpty(logFieldEntity.getChildrenListStr())){
                continue;
            }
            List<LogFieldEntity> childrenList = JSONArray.parseArray(logFieldEntity.getChildrenListStr(),LogFieldEntity.class);
            if(org.springframework.util.CollectionUtils.isEmpty(fieldList)){
                continue;
            }
            for(LogFieldEntity chiledFiled : childrenList){
                childrenMap.put(chiledFiled.getFieldName(),chiledFiled);
            }
        }
        return logTemplateEntity;
    }
}
