/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.annotation.Klock;
import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.availablelist.repositories.CusAvailablelistRepositories;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.utils.CusAvailablelistUtil;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.Handle;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.dms.promotion.PromotionPolicyFeign;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.util.ContextUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.EsUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"cusAvailablelistServiceExpand"})
@Service(value="cusAvailablelistService")
public class CusAvailablelistServiceImpl
implements CusAvailablelistService {
    private static final Logger log = LoggerFactory.getLogger(CusAvailablelistServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private CusAvailablelistRepositories cusAvailablelistRepositories;
    @Resource
    private IMdmCustomerMsgService iMdmCustomerMsgService;
    @Resource
    private AvailableListRuleService availableListRuleService;
    @Resource
    private IMdmProductService iMdmProductService;
    @Resource
    private Handle handle;
    @Resource
    private Advise advise;
    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;
    @Autowired
    private ContextUtil contextUtil;
    @Resource
    private IMdmPriceSettingService iMdmPriceSettingService;
    @Autowired
    private PromotionPolicyFeign promotionPolicyFeign;

    @Override
    public void reFresh(List<MdmProductAdviseRespVo> goods, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> ofenGoodsCodes = new ArrayList<String>();
        if (EsUtil.indexExsit(this.elasticsearchTemplate, CusAvailablelistEntity.class, this.redissonUtil)) {
            List<CusAvailablelistEntity> ofenGoods = this.cusAvailablelistRepositories.findByCusCodeAndOfenFlag(cusCode, CusAvailablelistUtil.OFENFLAG.YES.getCode());
            if (!CollectionUtils.isEmpty(ofenGoods)) {
                ofenGoodsCodes = ofenGoods.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList());
            }
            DeleteQuery deleteQuery = new DeleteQuery();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusCode.keyword", (String)cusCode));
            deleteQuery.setQuery((QueryBuilder)boolQueryBuilder);
            this.elasticsearchTemplate.delete(deleteQuery, CusAvailablelistEntity.class);
            this.elasticsearchTemplate.refresh("cusavailablelistindex");
        }
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        this.cusAvailablelistRepositories.saveAll(CusAvailablelistUtil.packageEntities(goods, cusCode, ofenGoodsCodes));
        this.elasticsearchTemplate.refresh("cusavailablelistindex");
        this.advise.remaveTarget(this.customerChangeAdviseTargetStrategy, cusCode);
    }

    @Override
    @Klock(keys={"cusallock", "#cusCode"}, waitTime=20L, leaseTime=5L)
    public void reFresh(String cusCode) {
        List<MdmProductAdviseRespVo> goodsList;
        Map<String, String> cusList = this.iMdmCustomerMsgService.findOrgCodeByCustomerCodeList(Lists.newArrayList((Object[])new String[]{cusCode}));
        if (CollectionUtils.isEmpty(cusList)) {
            return;
        }
        List<String> goodsCodes = this.availableListRuleService.findGoodsByCusCodeAndOrgCode(cusCode, cusList.get(cusCode));
        List<MdmProductAdviseRespVo> goods = new ArrayList<MdmProductAdviseRespVo>(0);
        if (!CollectionUtils.isEmpty(goodsCodes) && !CollectionUtils.isEmpty(goodsList = this.iMdmProductService.adviseQuery(goodsCodes))) {
            goods = goodsList;
        }
        this.reFresh(goods, cusCode);
    }

    @Override
    public void reFresh(List<String> cusCodes) {
        if (CollectionUtils.isEmpty(cusCodes)) {
            return;
        }
        for (String cusCode : cusCodes) {
            try {
                CusAvailablelistService cusAvailablelistService = (CusAvailablelistService)ContextUtil.getBean(CusAvailablelistService.class);
                cusAvailablelistService.reFresh(cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5237\u65b0\u5931\u8d25\uff0c\u5ba2\u6237:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    public void reFresh() {
        List<Object> list = this.handle.searchAllTarget(this.customerChangeAdviseTargetStrategy);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List codes = JSON.parseArray((String)JSON.toJSONString(list), String.class);
        this.reFresh(codes);
    }

    @Override
    public PageResult<CusAvailablelistVo> list(CusAvailablelistVo cusAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, CusAvailablelistEntity.class, this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cusCode.keyword", (String)cusAvailablelistVo.getCusCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)cusAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductLevelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)cusAvailablelistVo.getProductLevelCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)cusAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)cusAvailablelistVo.getProductName()));
        }
        if (null != cusAvailablelistVo.getOfenFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ofenFlag", (String)cusAvailablelistVo.getOfenFlag().toString()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"cusavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(cusAvailablelistVo.getPageNum() - 1), (int)cusAvailablelistVo.getPageSize())).build()), CusAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<CusAvailablelistVo> reList = new ArrayList<CusAvailablelistVo>(list.size());
        for (CusAvailablelistEntity entity : list) {
            CusAvailablelistVo vo = new CusAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            vo.setFormInstanceId(vo.getFictitiousId());
            reList.add(vo);
        }
        if (!StringUtils.isEmpty((Object)cusAvailablelistVo.getCusCode())) {
            Map<String, BigDecimal> map = this.iMdmPriceSettingService.findPriceByGoodsAndCusCode(reList.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()), cusAvailablelistVo.getCusCode());
            for (CusAvailablelistVo vo : reList) {
                vo.setPrice(map.get(vo.getProductCode()));
            }
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public void delByFictitiousId(String fictitiousId) {
        if (StringUtils.isEmpty((Object)fictitiousId)) {
            return;
        }
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, CusAvailablelistEntity.class, this.redissonUtil)) {
            return;
        }
        this.cusAvailablelistRepositories.deleteByFictitiousId(fictitiousId);
    }

    @Override
    public void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (CollectionUtils.isEmpty(mdmProductAdviseRespVos)) {
            return;
        }
        this.updateCusByGoodsCodes(mdmProductAdviseRespVos);
    }

    @Override
    public void delByGoodsCodes(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return;
        }
        this.cusAvailablelistRepositories.deleteByProductCodeIn(goodsCodes);
    }

    @Override
    public void ofenByfictitiousIds(List<String> fictitiousIds, CusAvailablelistUtil.OFENFLAG ofenflag) {
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByFictitiousIdIn(fictitiousIds);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (CusAvailablelistEntity entity : entities) {
            entity.setOfenFlag(ofenflag.getCode());
        }
        this.cusAvailablelistRepositories.saveAll(entities);
    }

    @Override
    public Map<String, CusAvailablelistVo> findGoodsByCusAndGoodsCodes(List<String> goodsCodes, String cusCode) {
        if (StringUtils.isEmpty((Object)cusCode) || CollectionUtils.isEmpty(goodsCodes)) {
            return new HashMap<String, CusAvailablelistVo>();
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCodeIn(cusCode, goodsCodes);
        Map<Object, Object> entityMap = new HashMap();
        if (!CollectionUtils.isEmpty(entities)) {
            entityMap = entities.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, Function.identity(), (key1, key2) -> key2));
        }
        HashMap<String, CusAvailablelistVo> reMap = new HashMap<String, CusAvailablelistVo>(goodsCodes.size());
        for (String goodsCode : goodsCodes) {
            CusAvailablelistEntity entity = (CusAvailablelistEntity)((Object)entityMap.get(goodsCode));
            CusAvailablelistVo vo = null;
            if (entity != null) {
                vo = new CusAvailablelistVo();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            }
            reMap.put(goodsCode, vo);
        }
        return reMap;
    }

    @Override
    public CusAvailablelistVo findByFictitiousId(String id) {
        CusAvailablelistEntity entity = this.cusAvailablelistRepositories.findByFictitiousId(id);
        if (null == entity) {
            return null;
        }
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFormInstanceId(vo.getFictitiousId());
        return vo;
    }

    @Override
    public Map<String, Object> findGoodsDetailAndPromotionByCode(String goodsCode, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u8bf7\u767b\u5f55!");
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        reMap.put("goods", null);
        reMap.put("promotion", null);
        if (StringUtils.isEmpty((Object)goodsCode)) {
            return reMap;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCode(cusCode, goodsCode);
        if (CollectionUtils.isEmpty(entities)) {
            return reMap;
        }
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entities.get(0)), (Object)vo);
        reMap.put("goods", vo);
        Map<String, BigDecimal> map = this.iMdmPriceSettingService.findPriceByGoodsAndCusCode(Arrays.asList(goodsCode), cusCode);
        vo.setPrice(map.get(vo.getProductCode()));
        reMap.put("promotion", this.promotionPolicyFeign.loadPromotionPolicyInfoByCustAndProduct(cusCode, goodsCode).getResult());
        return reMap;
    }

    @Override
    public CusAvailablelistVo findGoodsDetailByCode(String goodsCode, String cusCode) {
        ValidateUtils.validate((Object)cusCode, (String)"\u8bf7\u767b\u5f55!");
        if (StringUtils.isEmpty((Object)goodsCode)) {
            return null;
        }
        List<CusAvailablelistEntity> entities = this.cusAvailablelistRepositories.findByCusCodeAndProductCode(cusCode, goodsCode);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        CusAvailablelistVo vo = new CusAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entities.get(0)), (Object)vo);
        Map<String, BigDecimal> map = this.iMdmPriceSettingService.findPriceByGoodsAndCusCode(Arrays.asList(goodsCode), cusCode);
        vo.setPrice(map.get(vo.getProductCode()));
        return vo;
    }

    private void updateCusByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, CusAvailablelistEntity.class, this.redissonUtil)) {
            return;
        }
        List<CusAvailablelistEntity> cusAvailablelistEntities = this.cusAvailablelistRepositories.findByProductCodeIn((mdmProductAdviseRespVos = mdmProductAdviseRespVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getProductCode())).collect(Collectors.toList())).stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(cusAvailablelistEntities)) {
            return;
        }
        Map<String, MdmProductAdviseRespVo> goodsMap = mdmProductAdviseRespVos.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, a -> a, (k1, k2) -> k1));
        int pageSize = 500;
        int total = cusAvailablelistEntities.size();
        ArrayList<CusAvailablelistEntity> entities = new ArrayList<CusAvailablelistEntity>(pageSize);
        for (int i = 0; i < total; ++i) {
            CusAvailablelistEntity entity = cusAvailablelistEntities.get(i);
            MdmProductAdviseRespVo vo2 = goodsMap.get(entity.getProductCode());
            if (null != vo2) {
                BeanUtils.copyProperties((Object)vo2, (Object)((Object)entity));
                entities.add(entity);
            }
            if (entities.size() <= 0 || entities.size() != pageSize && i != total - 1) continue;
            this.cusAvailablelistRepositories.deleteByFictitiousIdIn(entities.stream().map(CusAvailablelistEntity::getFictitiousId).collect(Collectors.toList()));
            this.cusAvailablelistRepositories.saveAll(entities);
            entities.clear();
        }
        this.elasticsearchTemplate.refresh("cusavailablelistindex");
    }
}

