/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.availablelist.entity.TerminalAvailablelistEntity;
import com.biz.crm.availablelist.repositories.TerminalAvailablelistRepositories;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.availablelist.utils.TerminalAvailablelistUtil;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.Handle;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.EsUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"terminalAvailablelistServiceExpand"})
@Service(value="terminalAvailablelistService")
public class TerminalAvailablelistServiceImpl
implements TerminalAvailablelistService {
    private static final Logger log = LoggerFactory.getLogger(TerminalAvailablelistServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private TerminalAvailablelistRepositories terminalAvailablelistRepositories;
    @Resource
    private IMdmTerminalService iMdmTerminalService;
    @Resource
    private IMdmProductService iMdmProductService;
    @Resource
    private AvailableListRuleService availableListRuleService;
    @Resource
    private Handle handle;
    @Resource
    private Advise advise;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;

    @Override
    public void reFresh(List<MdmProductAdviseRespVo> goods, String terminalCode) {
        ValidateUtils.validate((Object)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (EsUtil.indexExsit(this.elasticsearchTemplate, TerminalAvailablelistEntity.class, this.redissonUtil)) {
            DeleteQuery deleteQuery = new DeleteQuery();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalCode.keyword", (String)terminalCode));
            deleteQuery.setQuery((QueryBuilder)boolQueryBuilder);
            this.elasticsearchTemplate.delete(deleteQuery, TerminalAvailablelistEntity.class);
            this.elasticsearchTemplate.refresh("terminalavailablelistindex");
        }
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        this.terminalAvailablelistRepositories.saveAll(TerminalAvailablelistUtil.packageEntities(goods, terminalCode));
        this.elasticsearchTemplate.refresh("terminalavailablelistindex");
        this.advise.remaveTarget(this.terminalChangeAdviseTargetStrategy, terminalCode);
    }

    @Override
    public void reFresh(String terminalCode) {
        List<MdmProductAdviseRespVo> goodsList;
        Map<String, String> terminalList = this.iMdmTerminalService.findOrgCodeByTerminalCodeList(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(terminalList)) {
            return;
        }
        List<String> goodsCodes = this.availableListRuleService.findGoodsByTerminalCodeAndOrgCode(terminalCode, terminalList.get(terminalCode));
        List<MdmProductAdviseRespVo> goods = new ArrayList<MdmProductAdviseRespVo>(0);
        if (!CollectionUtils.isEmpty(goodsCodes) && !CollectionUtils.isEmpty(goodsList = this.iMdmProductService.adviseQuery(goodsCodes))) {
            goods = goodsList;
        }
        this.reFresh(goods, terminalCode);
    }

    @Override
    public void reFresh(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        for (String cusCode : terminalCodes) {
            try {
                this.reFresh(cusCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5237\u65b0\u5931\u8d25\uff0c\u7ec8\u7aef:" + cusCode, (Throwable)e);
            }
        }
    }

    @Override
    public void reFresh() {
        List<Object> list = this.handle.searchAllTarget(this.terminalChangeAdviseTargetStrategy);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List codes = JSON.parseArray((String)JSON.toJSONString(list), String.class);
        this.reFresh(codes);
    }

    @Override
    public void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (CollectionUtils.isEmpty(mdmProductAdviseRespVos)) {
            return;
        }
        this.updateTerminalByGoodsCodes(mdmProductAdviseRespVos);
    }

    private void updateTerminalByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, TerminalAvailablelistEntity.class, this.redissonUtil)) {
            return;
        }
        List<TerminalAvailablelistEntity> terminalAvailablelistEntities = this.terminalAvailablelistRepositories.findByProductCodeIn((mdmProductAdviseRespVos = mdmProductAdviseRespVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getProductCode())).collect(Collectors.toList())).stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(terminalAvailablelistEntities)) {
            return;
        }
        Map<String, MdmProductAdviseRespVo> goodsMap = mdmProductAdviseRespVos.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, a -> a, (k1, k2) -> k1));
        int pageSize = 500;
        int total = terminalAvailablelistEntities.size();
        ArrayList<TerminalAvailablelistEntity> entities = new ArrayList<TerminalAvailablelistEntity>(pageSize);
        for (int i = 0; i < total; ++i) {
            TerminalAvailablelistEntity entity = terminalAvailablelistEntities.get(i);
            MdmProductAdviseRespVo vo2 = goodsMap.get(entity.getProductCode());
            if (null != vo2) {
                BeanUtils.copyProperties((Object)vo2, (Object)((Object)entity));
                entities.add(entity);
            }
            if (entities.size() != pageSize && i != total - 1) continue;
            this.terminalAvailablelistRepositories.deleteByFictitiousIdIn(entities.stream().map(TerminalAvailablelistEntity::getFictitiousId).collect(Collectors.toList()));
            this.terminalAvailablelistRepositories.saveAll(entities);
            entities.clear();
        }
        this.elasticsearchTemplate.refresh("terminalavailablelistindex");
    }

    @Override
    public void delByGoodsCodes(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return;
        }
        this.terminalAvailablelistRepositories.deleteByProductCodeIn(goodsCodes);
    }

    @Override
    public PageResult<TerminalAvailablelistVo> list(TerminalAvailablelistVo terminalAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, TerminalAvailablelistEntity.class, this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalCode.keyword", (String)terminalAvailablelistVo.getTerminalCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)terminalAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductLevelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)terminalAvailablelistVo.getProductLevelCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)terminalAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)terminalAvailablelistVo.getProductName()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"terminalavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(terminalAvailablelistVo.getPageNum() - 1), (int)terminalAvailablelistVo.getPageSize())).build()), TerminalAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<TerminalAvailablelistVo> reList = new ArrayList<TerminalAvailablelistVo>(list.size());
        for (TerminalAvailablelistEntity entity : list) {
            TerminalAvailablelistVo vo = new TerminalAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            vo.setFormInstanceId(vo.getFictitiousId());
            reList.add(vo);
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public void delByFictitiousId(String fictitiousId) {
        if (StringUtils.isEmpty((Object)fictitiousId)) {
            return;
        }
        if (!EsUtil.indexExsit(this.elasticsearchTemplate, TerminalAvailablelistEntity.class, this.redissonUtil)) {
            return;
        }
        this.terminalAvailablelistRepositories.deleteByFictitiousId(fictitiousId);
    }

    @Override
    public TerminalAvailablelistVo findByFictitiousId(String id) {
        TerminalAvailablelistEntity entity = this.terminalAvailablelistRepositories.findByFictitiousId(id);
        if (null == entity) {
            return null;
        }
        TerminalAvailablelistVo vo = new TerminalAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFormInstanceId(vo.getFictitiousId());
        return vo;
    }
}

