/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDict;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class CrmDictMethodAop {
    @Around(value="@annotation(CrmDictMethod)")
    public Object around(ProceedingJoinPoint pjp) {
        Object proceed = pjp.proceed();
        if (proceed instanceof Result) {
            HashMap map = Maps.newHashMap();
            Object data = CrmDictMethodAop.objParse(Result.class, proceed).getResult();
            if (data != null) {
                if (data.getClass().isArray() || data instanceof Collection) {
                    Collection<Object> collections = CrmDictMethodAop.listParse(Object.class, data);
                    for (Object datum : collections) {
                        this.convertData(datum, map);
                    }
                } else if (data instanceof PageResult) {
                    Collection<Object> innerData = CrmDictMethodAop.listParse(Object.class, CrmDictMethodAop.objParse(PageResult.class, data).getData());
                    for (Object obj : innerData) {
                        this.convertData(obj, map);
                    }
                } else {
                    this.convertData(data, map);
                }
            }
        }
        return proceed;
    }

    public static <T> T objParse(Class<T> clazz, Object value) {
        return clazz.cast(value);
    }

    public static <T> Collection<T> listParse(Class<T> clazz, Object obj) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object o : (Collection)obj) {
            result.add(clazz.cast(o));
        }
        return result;
    }

    private void convertData(Object o, Map<String, Map<String, String>> map) {
        for (Class<?> sourceClass = o.getClass(); sourceClass != Object.class; sourceClass = sourceClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = sourceClass.getDeclaredFields()) {
                String typeCode;
                CrmDict crmDict = field.getAnnotation(CrmDict.class);
                if (crmDict == null || StringUtils.isEmpty((String)(typeCode = this.getTypeCode(crmDict, sourceClass, o)))) continue;
                String dictCodeField = crmDict.dictCodeField();
                Field declaredField = sourceClass.getDeclaredField(dictCodeField);
                declaredField.setAccessible(true);
                String dictCode = (String)declaredField.get(o);
                if (StringUtils.isEmpty((String)dictCode)) continue;
                field.setAccessible(true);
                Map<String, String> dictTypeMap = map.get(typeCode);
                if (dictTypeMap != null) {
                    String val = dictTypeMap.get(dictCode);
                    if (StringUtils.isEmpty((String)val)) continue;
                    field.set(o, val);
                    continue;
                }
                Map dictMap = DictUtil.dictMap((String)typeCode);
                if (dictMap == null) continue;
                map.put(typeCode, dictMap);
                String val = (String)dictMap.get(dictCode);
                if (StringUtils.isEmpty((String)val)) continue;
                field.set(o, val);
            }
        }
    }

    private String getTypeCode(CrmDict crmDict, Class<?> sourceClass, Object o) {
        String type = crmDict.type();
        if ("1".equals(type)) {
            return crmDict.typeCode();
        }
        if ("2".equals(type)) {
            String typeCode = crmDict.typeCode();
            Field typeCodeField = sourceClass.getDeclaredField(typeCode);
            typeCodeField.setAccessible(true);
            return (String)typeCodeField.get(o);
        }
        return null;
    }
}

