/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cusorg.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.cusorg.service.CusOrgService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.EditCusOrgReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5ba2\u6237\u7ec4\u7ec7", tags={"\u5ba2\u6237\u7ec4\u7ec7"})
@RestController
@RequestMapping(value={"/cus/org"})
@CrmGlobalLog
public class CusOrgController {
    private final CusOrgService cusOrgService;

    public CusOrgController(CusOrgService cusOrgService) {
        this.cusOrgService = cusOrgService;
    }

    @ApiOperation(value="\u6dfb\u52a0\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"add"})
    public Result<Object> add(@RequestBody CusOrgVo cusOrgVo) {
        this.cusOrgService.add(cusOrgVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"/query"})
    public Result<CusOrgVo> query(@RequestBody CusOrgVo cusOrgVo) {
        return Result.ok((Object)this.cusOrgService.query(cusOrgVo));
    }

    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"edit"})
    public Result<Object> edit(@RequestBody CusOrgVo cusOrgVo) {
        this.cusOrgService.edit(cusOrgVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5206\u9875\u641c\u7d22\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"list"})
    @CrmDictMethod
    public Result<PageResult<CusOrgVo>> list(@RequestBody CusOrgVo cusOrgVo) {
        return Result.ok(this.cusOrgService.list(cusOrgVo));
    }

    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u542f\u7528")
    @PostMapping(value={"enAbleBatch"})
    public Result<Object> enAbleBatch(@RequestBody ArrayList<String> ids) {
        this.cusOrgService.ableBatch(ids, CrmEnableStatusEnum.ENABLE);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u7981\u7528")
    @PostMapping(value={"disAbleBatch"})
    public Result<Object> disAbleBatch(@RequestBody @NotEmpty ArrayList<String> ids) {
        this.cusOrgService.disableBatch(ids, CrmEnableStatusEnum.DISABLE);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"delBatch"})
    public Result<Object> delBatch(@RequestBody @NotEmpty ArrayList<String> ids) {
        this.cusOrgService.stateBatch(ids, CrmDelFlagEnum.DELETE);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b")
    @PostMapping(value={"/findDetailsByFormInstanceId"})
    @CrmDictMethod
    public Result<CusOrgVo> findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        return Result.ok((Object)this.cusOrgService.findDetailsByFormInstanceId(formInstanceId));
    }

    @ApiOperation(value="\u5ba2\u6237\u7ec4\u7ec7\u6811")
    @PostMapping(value={"/tree"})
    public Result<List<CusOrgTreeRespVo>> cusOrgTree(@RequestBody CusOrgVo cusOrgVo) {
        return Result.ok(this.cusOrgService.cusOrgTree(cusOrgVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u975e\u5f53\u524d\u53ca\u5b50\u7ea7\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"/edit_tree"})
    public Result<List<CusOrgTreeRespVo>> editParentTree(@RequestBody EditCusOrgReqVo editCusOrgReqVo) {
        return Result.ok(this.cusOrgService.editParentTree(editCusOrgReqVo));
    }
}

