/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.base.CustomerTerminalQueryContext;
import com.biz.crm.customer.mapper.MdmCustomerTerminalMapper;
import com.biz.crm.customer.model.MdmCustomerTerminalEntity;
import com.biz.crm.customer.service.IMdmCustomerTerminalService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmCustomerTerminalServiceImpl
extends ServiceImpl<MdmCustomerTerminalMapper, MdmCustomerTerminalEntity>
implements IMdmCustomerTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTerminalServiceImpl.class);
    private final CustomerTerminalQueryContext customerTerminalQueryContext;

    @Autowired
    public MdmCustomerTerminalServiceImpl(CustomerTerminalQueryContext customerTerminalQueryContext) {
        this.customerTerminalQueryContext = customerTerminalQueryContext;
    }

    @Override
    public void correlatedTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        Set terminalIdList = mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList();
        List collect = terminalIdList.stream().map(x -> {
            MdmCustomerTerminalEntity mdmCustomerTerminalEntity = new MdmCustomerTerminalEntity();
            mdmCustomerTerminalEntity.setCustomerCode(mdmCustomerCorrelatedTerminalReqVo.getCustomerCode());
            mdmCustomerTerminalEntity.setTerminalCode((String)x);
            mdmCustomerTerminalEntity.setId(UUID.randomUUID().toString());
            return mdmCustomerTerminalEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> customerTerminalPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return this.customerTerminalQueryContext.doOperate(mdmCustomerTerminalReqVo);
    }

    @Override
    public void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReqVo.getCustomerCode())).in(MdmCustomerTerminalEntity::getTerminalCode, new Object[]{mdmCustomerCorrelatedTerminalReqVo.getCustomerCode()})).remove();
    }

    @Override
    public void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerTerminalEntity::getTerminalCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getOldCustomerCode())).in(MdmCustomerTerminalEntity::getTerminalCode, (Collection)mdmCustomerCorrelatedTerminalReplaceReqVo.getTerminalCodeList())).set(MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getNewCustomerCode())).update();
    }
}

