/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dict.entity.DictEntity;
import com.biz.crm.dict.mapper.DictMapper;
import com.biz.crm.dict.service.DictService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, DictEntity>
implements DictService {
    private final DictMapper dictMapper;

    @Autowired
    public DictServiceImpl(DictMapper dictMapper) {
        this.dictMapper = dictMapper;
    }

    @Override
    public DictEntity one(String typeCode, String dictCode) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"a.dict_code", (Object)typeCode)).eq((Object)"b.dict_value", (Object)dictCode);
        return this.dictMapper.one((QueryWrapper<DictEntity>)wrapper);
    }

    @Override
    public Map<String, String> list(String typeCode) {
        return Optional.of(this.dictMapper.list((QueryWrapper<DictEntity>)((QueryWrapper)Wrappers.query().eq((Object)"a.dict_code", (Object)typeCode))).stream().collect(Collectors.toMap(DictEntity::getDictValue, DictEntity::getDictKey))).orElse(Collections.emptyMap());
    }

    @Override
    public Map<String, Map<String, String>> typeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Collections.emptyMap();
        }
        List<DictEntity> list = this.dictMapper.list((QueryWrapper<DictEntity>)((QueryWrapper)Wrappers.query().in((Object)"a.dict_code", typeCodeList)));
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        Map<String, List<DictEntity>> collect = list.stream().collect(Collectors.groupingBy(DictEntity::getDictCode));
        Set<Map.Entry<String, List<DictEntity>>> entries = collect.entrySet();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<DictEntity>> entry : entries) {
            List<DictEntity> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            map.put(entry.getKey(), value.stream().collect(Collectors.toMap(DictEntity::getDictValue, DictEntity::getDictKey)));
        }
        return map;
    }
}

