/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.humanarea.manager.MdmOrgManager;
import com.biz.crm.humanarea.mapper.EngineOrgMapper;
import com.biz.crm.humanarea.model.EngineOrgEntity;
import com.biz.crm.humanarea.service.IEngineOrgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgTreeRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmBaseOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgTerminalPageReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.bizunited.platform.common.vo.UuidVo;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineOrgServiceExpandImpl"})
@CrmGlobalLog
public class EngineOrgServiceImpl
extends ServiceImpl<EngineOrgMapper, EngineOrgEntity>
implements IEngineOrgService {
    private static final Logger log = LoggerFactory.getLogger(EngineOrgServiceImpl.class);
    @Resource
    private EngineOrgMapper engineOrgMapper;
    @Resource
    private MdmOrgManager mdmOrgManager;

    @Override
    public PageResult<EngineOrgRespVo> findList(EngineOrgReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((String)reqVo.getOrgCode()), (Object)"a.org_code", (Object)reqVo.getOrgCode())).like(!StringUtils.isEmpty((String)reqVo.getOrgName()), (Object)"a.org_name", (Object)reqVo.getOrgName())).eq(!StringUtils.isEmpty((String)reqVo.getParentId()), (Object)"b.id", (Object)reqVo.getParentId())).eq(!StringUtils.isEmpty((String)reqVo.getEnableStatus()), (Object)"b.enable_status", (Object)reqVo.getEnableStatus());
        List<EngineOrgRespVo> list = this.engineOrgMapper.findList((Page<EngineOrgRespVo>)page, (QueryWrapper<EngineOrgRespVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineOrgRespVo query(EngineOrgReqVo reqVo) {
        EngineOrgEntity one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getOrgCode()), EngineOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).eq(StringUtils.isNotEmpty((String)reqVo.getId()), EngineOrgEntity::getId, (Object)reqVo.getId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (EngineOrgRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineOrgRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineOrgReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgLevel(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)reqVo.getOrgCode())) {
            reqVo.setOrgCode(CodeUtil.getCode());
        }
        EngineOrgEntity entity = (EngineOrgEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineOrgEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineOrgReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, EngineOrgEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineOrgReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.engineOrgMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (EngineOrgEntity engineOrgEntity : list) {
            }
        }
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(EngineOrgReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineOrgEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(EngineOrgReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineOrgEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<EngineOrgRespVo> listCondition(EngineOrgReqVo engineOrgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)engineOrgReqVo.getOrgCode()), EngineOrgEntity::getOrgCode, (Object)engineOrgReqVo.getOrgCode())).like(!StringUtils.isEmpty((String)engineOrgReqVo.getOrgName()), EngineOrgEntity::getOrgName, (Object)engineOrgReqVo.getOrgName())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, EngineOrgRespVo.class);
    }

    @Override
    public PageResult<MdmTerminalRespVo> findList(MdmOrgTerminalPageReqVo mdmOrgTerminalPageReqVo) {
        return this.mdmOrgManager.findList(mdmOrgTerminalPageReqVo);
    }

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmOrgCustomerPageReqVo mdmOrgCustomerPageReqVo) {
        return this.mdmOrgManager.findList(mdmOrgCustomerPageReqVo);
    }

    @Override
    public void updateOrgCode(MdmOrgCustomerUpdateReqVo mdmOrgCustomerUpdateReqVo) {
        this.mdmOrgManager.updateOrgCode(mdmOrgCustomerUpdateReqVo);
    }

    @Override
    public void terminalOrgCode(MdmOrgTerminalReqVo mdmOrgTerminalReqVo) {
        this.mdmOrgManager.terminalOrgCode(mdmOrgTerminalReqVo);
    }

    @Override
    public List<EngineOrgRespVo> findCurrentAndSubOrgCodeList(EngineOrgSearchReqVo engineOrgSearchReqVo) {
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)engineOrgSearchReqVo);
        List orgCodeList = engineOrgSearchReqVo.getOrgCodeList();
        String orgCodeOrName = engineOrgSearchReqVo.getOrgCodeOrName();
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().and(!StringUtils.isEmpty((String)orgCodeOrName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"org_code", (Object)orgCodeOrName)).or()).like((Object)"org_name", (Object)orgCodeOrName);
        })).in(CollectionUtils.isNotEmpty((Collection)orgCodeList), (Object)"org_code", (Collection)orgCodeList);
        List<EngineOrgRespVo> list = this.engineOrgMapper.pageCondition((Page<EngineOrgRespVo>)new Page((long)engineOrgSearchReqVo.getPageNum().intValue(), (long)engineOrgSearchReqVo.getPageSize().intValue()), (QueryWrapper<EngineOrgRespVo>)wrapper);
        if (CollectionUtils.isEmpty((Collection)orgCodeList) || CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<EngineOrgRespVo> result = new ArrayList<EngineOrgRespVo>();
        List collect = list.stream().filter(x -> orgCodeList.contains(x.getOrgCode())).collect(Collectors.toList());
        while (!CollectionUtils.isEmpty(collect)) {
            result.addAll(collect);
            List currentOrgIdList = collect.stream().map(UuidVo::getId).collect(Collectors.toList());
            collect = list.stream().filter(x -> currentOrgIdList.contains(x.getParentId())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<EngineOrgTreeRespVo> findCurrentAndSubOrgTree(EngineOrgSearchReqVo engineOrgSearchReqVo) {
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)engineOrgSearchReqVo);
        List orgCodeList = engineOrgSearchReqVo.getOrgCodeList();
        String orgCodeOrName = engineOrgSearchReqVo.getOrgCodeOrName();
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((String)engineOrgSearchReqVo.getEnableStatus()), (Object)"enable_status", (Object)engineOrgSearchReqVo.getEnableStatus())).and(!StringUtils.isEmpty((String)orgCodeOrName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"org_code", (Object)orgCodeOrName)).or()).like((Object)"org_name", (Object)orgCodeOrName);
        });
        List<EngineOrgTreeRespVo> list = this.engineOrgMapper.treeCondition((Page<EngineOrgTreeRespVo>)new Page((long)engineOrgSearchReqVo.getPageNum().intValue(), (long)engineOrgSearchReqVo.getPageSize().intValue()), (QueryWrapper<EngineOrgTreeRespVo>)wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().filter(x -> CollectionUtils.isEmpty((Collection)orgCodeList) ? StringUtils.isEmpty((String)x.getParentId()) : orgCodeList.contains(x.getOrgCode())).peek(x -> x.setChildren(this.setUpChildren(x.getId(), list))).collect(Collectors.toList());
    }

    @Override
    public List<EngineOrgRespVo> unSubOrgList(String orgCode) {
        return CrmBeanUtil.copyList((List)this.list(), EngineOrgRespVo.class);
    }

    public List<EngineOrgTreeRespVo> setUpChildren(String id, List<EngineOrgTreeRespVo> list) {
        List collect;
        if (!(StringUtils.isEmpty((String)id) || CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(collect = list.stream().filter(x -> id.equals(x.getParentId())).collect(Collectors.toList())))) {
            return collect.stream().map(x -> x.setChildren(this.setUpChildren(x.getId(), list))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

