/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.humanarea.manager.MdmUserManager;
import com.biz.crm.humanarea.mapper.EngineUserMapper;
import com.biz.crm.humanarea.model.EngineOrgEntity;
import com.biz.crm.humanarea.model.EnginePositionEntity;
import com.biz.crm.humanarea.model.EngineRoleCustomerEntity;
import com.biz.crm.humanarea.model.EngineRolePositionEntity;
import com.biz.crm.humanarea.model.EngineUserEntity;
import com.biz.crm.humanarea.model.EngineUserPositionEntity;
import com.biz.crm.humanarea.service.EnginePositionService;
import com.biz.crm.humanarea.service.EngineRoleCustomerService;
import com.biz.crm.humanarea.service.EngineRolePositionService;
import com.biz.crm.humanarea.service.EngineUserPositionService;
import com.biz.crm.humanarea.service.IEngineOrgService;
import com.biz.crm.humanarea.service.IEngineUserService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.enums.PrimaryPositionEnum;
import com.biz.crm.nebular.mdm.humanarea.EngineUserCustomerVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserPositionVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserUpdatePasswordReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserViewVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUnbindUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalReqVo;
import com.biz.crm.position.model.MdmPositionLevelEntity;
import com.biz.crm.position.service.IMdmPositionLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"EngineUserServiceExpandImpl"})
public class EngineUserServiceImpl
extends ServiceImpl<EngineUserMapper, EngineUserEntity>
implements IEngineUserService {
    private static final Logger log = LoggerFactory.getLogger(EngineUserServiceImpl.class);
    @Resource
    private EngineUserMapper engineUserMapper;
    @Resource
    private MdmUserManager mdmUserManager;
    @Resource
    private EngineUserPositionService engineUserPositionService;
    @Resource
    private IMdmPositionLevelService mdmPositionLevelService;
    @Resource
    private EnginePositionService enginePositionService;
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private EngineRolePositionService engineRolePositionService;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private EngineRoleCustomerService engineRoleCustomerService;
    private final String POSITION_SUFFIX_REGEX = "^[1-9]\\d*$";

    @Override
    public PageResult<EngineUserRespVo> findList(EngineUserPageReqVo engineUserPageReqVo) {
        Page page = new Page((long)engineUserPageReqVo.getPageNum().intValue(), (long)engineUserPageReqVo.getPageSize().intValue());
        List<EngineUserRespVo> list = this.engineUserMapper.findList((Page<EngineUserRespVo>)page, engineUserPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> customerPage(MdmUserRelationCustomerPageReqVo mdmUserRelationCustomerPageReqVo) {
        String queryType;
        switch (queryType = mdmUserRelationCustomerPageReqVo.getQueryType()) {
            case "1": {
                return this.mdmUserManager.findUnRelationAnyUser(mdmUserRelationCustomerPageReqVo);
            }
            case "2": {
                return this.mdmUserManager.findUnRelationCurrentUser(mdmUserRelationCustomerPageReqVo);
            }
            case "3": {
                return this.mdmUserManager.findRelationCurrentUser(mdmUserRelationCustomerPageReqVo);
            }
        }
        return new PageResult();
    }

    @Override
    public void relationCustomer(MdmUserRelationCustomerReqVo mdmUserRelationCustomerReqVo) {
        this.mdmUserManager.relationCustomer(mdmUserRelationCustomerReqVo);
    }

    @Override
    public List<String> findAllPositionCodeByUser(String userAccount) {
        return this.mdmUserManager.findAllPositionCodeByUser(userAccount);
    }

    @Override
    public void unbindRelationCustomer(MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.mdmUserManager.unbindRelationCustomer(mdmUnbindUserRelationCustomerReqVo);
    }

    @Override
    public PageResult<MdmPositionSelectPageRespVo> positionSelect(MdmPositionSelectPageReqVo mdmPositionSelectPageReqVo) {
        return this.mdmUserManager.positionSelect(mdmPositionSelectPageReqVo);
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> terminalPage(MdmUserRelationTerminalPageReqVo mdmUserRelationTerminalPageReqVo) {
        switch (mdmUserRelationTerminalPageReqVo.getQueryType()) {
            case "1": {
                return this.mdmUserManager.findUnRelationAnyUser(mdmUserRelationTerminalPageReqVo);
            }
            case "2": {
                return this.mdmUserManager.findUnRelationCurrentUser(mdmUserRelationTerminalPageReqVo);
            }
            case "3": {
                return this.mdmUserManager.findRelationCurrentUser(mdmUserRelationTerminalPageReqVo);
            }
        }
        return new PageResult();
    }

    @Override
    public void unbindRelationTerminal(MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.mdmUserManager.unbindRelationTerminal(mdmUnbindUserRelationCustomerReqVo);
    }

    @Override
    public void relationTerminal(MdmUserRelationTerminalReqVo mdmUserRelationTerminalReqVo) {
        this.mdmUserManager.relationTerminal(mdmUserRelationTerminalReqVo);
    }

    @Override
    public EngineUserRespVo customerUserLogin(EngineUserReqVo engineUserReqVo) {
        String userAccount = engineUserReqVo.getUserAccount();
        String userPassword = engineUserReqVo.getUserPassword();
        Assert.hasText((String)userAccount, (String)"\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)userPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        engineUserReqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)userPassword));
        EngineUserRespVo engineUserRespVo = this.engineUserMapper.findCustomerUser(engineUserReqVo);
        Assert.notNull((Object)engineUserRespVo, (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        engineUserRespVo.setToken(UserUtils.getToken((String)userAccount));
        this.postLogin(engineUserRespVo);
        return engineUserRespVo;
    }

    private void postLogin(EngineUserRespVo engineUserRespVo) {
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(engineUserRespVo.getUserAccount());
        userRedis.setRealname(engineUserRespVo.getUserName());
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmUserManager.findPrimaryCustomer(engineUserRespVo.getUserAccount());
        if (mdmCustomerMsgRespVo != null) {
            userRedis.setCustcode(mdmCustomerMsgRespVo.getCustomerCode());
            userRedis.setCustname(mdmCustomerMsgRespVo.getCustomerName());
            userRedis.setOrgcode(mdmCustomerMsgRespVo.getOrgCode());
            userRedis.setOrgname(mdmCustomerMsgRespVo.getOrgName());
            engineUserRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
            engineUserRespVo.setOrgCode(mdmCustomerMsgRespVo.getOrgCode());
            engineUserRespVo.setOrgName(mdmCustomerMsgRespVo.getOrgName());
            engineUserRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        }
        UserUtils.setUser((String)engineUserRespVo.getToken(), (UserRedis)userRedis);
    }

    @Override
    public void updatePassword(EngineUserUpdatePasswordReqVo engineUserUpdatePasswordReqVo) {
        String newPassword = engineUserUpdatePasswordReqVo.getNewPassword();
        String oldPassword = engineUserUpdatePasswordReqVo.getOldPassword();
        String userAccount = engineUserUpdatePasswordReqVo.getUserAccount();
        Assert.notNull((Object)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)oldPassword, (String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)newPassword, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!oldPassword.equals(newPassword) ? 1 : 0) != 0, (String)"\u65b0\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        engineUserUpdatePasswordReqVo.setOldPassword(Md5EncryptionAndDecryption.encryPwd((String)oldPassword));
        engineUserUpdatePasswordReqVo.setNewPassword(Md5EncryptionAndDecryption.encryPwd((String)newPassword));
        this.engineUserMapper.updatePassword(engineUserUpdatePasswordReqVo);
    }

    @Override
    public void resetPassword(String userAccount) {
        Assert.hasText((String)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.engineUserMapper.resetPassword(userAccount);
    }

    @Override
    public EngineUserViewVo query(EngineUserReqVo engineUserReqVo) {
        EngineUserEntity one = (EngineUserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)engineUserReqVo.getUserAccount()), EngineUserEntity::getUserAccount, (Object)engineUserReqVo.getUserAccount())).eq(!StringUtils.isEmpty((String)engineUserReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)engineUserReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((String)engineUserReqVo.getUserPhone()), EngineUserEntity::getUserPhone, (Object)engineUserReqVo.getUserPhone())).last(DatabaseTypeUtil.SEGMENT)).one());
        EngineUserViewVo engineUserViewVo = (EngineUserViewVo)CrmBeanUtil.copy((Object)((Object)one), EngineUserViewVo.class);
        String userType = engineUserViewVo.getUserType();
        Assert.isTrue(("u".equals(userType) || "c".equals(userType) ? 1 : 0) != 0, (String)("\u7528\u6237\u7c7b\u578b[" + userType + "]\u53ea\u80fd\u662f\u7528\u6237\u6216\u5ba2\u6237"));
        if ("u".equals(userType)) {
            engineUserViewVo.setEngineUserPositionVos(this.engineUserMapper.findUserPositionList(engineUserViewVo.getUserAccount()));
        }
        if ("c".equals(userType)) {
            engineUserViewVo.setEngineUserCustomerVos(this.engineUserMapper.findCustomerList(engineUserReqVo.getUserAccount()));
        }
        return engineUserViewVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineUserViewVo engineUserViewVo) {
        if (StringUtils.isEmpty((String)engineUserViewVo.getUserCode())) {
            engineUserViewVo.setUserCode(CodeUtil.getCode());
        }
        engineUserViewVo.setId(UUID.randomUUID().toString());
        this.checkUser(engineUserViewVo);
        this.postUser(engineUserViewVo);
        EngineUserEntity userEntity = (EngineUserEntity)((Object)CrmBeanUtil.copy((Object)engineUserViewVo, EngineUserEntity.class));
        this.save((Object)userEntity);
    }

    private void postUser(EngineUserViewVo engineUserViewVo) {
        String userType = engineUserViewVo.getUserType();
        if ("u".equals(userType)) {
            this.setUser(engineUserViewVo);
        } else if ("c".equals(userType)) {
            this.setCustomer(engineUserViewVo);
        }
    }

    private void setCustomer(EngineUserViewVo engineUserViewVo) {
        List engineUserCustomerVos = engineUserViewVo.getEngineUserCustomerVos();
        Assert.notEmpty((Collection)engineUserCustomerVos, (String)"\u5ba2\u6237\u7528\u6237\u5fc5\u987b\u5173\u8054\u5ba2\u6237");
        List customerCodeList = engineUserCustomerVos.stream().map(EngineUserCustomerVo::getCustomerCode).collect(Collectors.toList());
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().in(MdmCustomerMsgEntity::getCustomerCode, customerCodeList)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        Assert.notEmpty((Collection)list, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
        long count = list.stream().filter(x -> "y".equals(x.getCustomerPrimary())).count();
        if (count != 1L) {
            list = list.stream().peek(x -> {
                x.setCustomerPrimary("n");
                x.setUserAccount(engineUserViewVo.getUserAccount());
            }).collect(Collectors.toList());
            ((MdmCustomerMsgEntity)((Object)list.get(0))).setCustomerPrimary("y");
            this.mdmCustomerMsgService.updateBatchById(list);
        }
        ((LambdaUpdateChainWrapper)this.engineRoleCustomerService.lambdaUpdate().in(EngineRoleCustomerEntity::getCustomerCode, customerCodeList)).remove();
        List collect = engineUserCustomerVos.stream().map(x -> {
            EngineRoleCustomerEntity engineRoleCustomerEntity = new EngineRoleCustomerEntity();
            engineRoleCustomerEntity.setCustomerCode(x.getCustomerCode());
            engineRoleCustomerEntity.setRoleCode(x.getRoleCode());
            engineRoleCustomerEntity.setId(UUID.randomUUID().toString());
            return engineRoleCustomerEntity;
        }).collect(Collectors.toList());
        this.engineRoleCustomerService.saveBatch(collect);
    }

    private void setUser(EngineUserViewVo engineUserViewVo) {
        List engineUserPositionVos = engineUserViewVo.getEngineUserPositionVos();
        List<String> positionCodeList = engineUserPositionVos.stream().map(EngineUserPositionVo::getPositionCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Assert.notEmpty(positionCodeList, (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> positionIdList = this.mdmUserManager.findPositionIdList(positionCodeList);
        Assert.notEmpty(positionCodeList, (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        String userId = engineUserViewVo.getId();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.engineUserPositionService.lambdaUpdate().eq(EngineUserPositionEntity::getUserId, (Object)userId)).set(EngineUserPositionEntity::getUserId, (Object)"")).update();
        List userPositionEntities = positionIdList.stream().map(x -> new EngineUserPositionEntity(userId, (String)x)).collect(Collectors.toList());
        this.engineUserPositionService.saveOrUpdateBatch(userPositionEntities);
        engineUserPositionVos.stream().filter(engineUserPositionVo -> "n".equals(engineUserPositionVo.getOperationType())).forEach(engineUserPositionVo -> {
            String positionLevelCode = engineUserPositionVo.getPositionLevelCode();
            Assert.hasText((String)positionLevelCode, (String)"\u65b0\u5efa\u804c\u4f4d\uff0c\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            MdmPositionLevelEntity mdmPositionLevelEntity = (MdmPositionLevelEntity)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionLevelService.lambdaQuery().eq(MdmPositionLevelEntity::getCode, (Object)positionLevelCode)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).one()));
            Assert.notNull((Object)((Object)mdmPositionLevelEntity), (String)("\u804c\u4f4d\u7ea7\u522b[" + positionLevelCode + "]\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528"));
            List enginePositionEntities = ((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionLevelCode, (Object)positionLevelCode)).list();
            String orgCode = engineUserPositionVo.getOrgCode();
            Assert.hasText((String)orgCode, (String)("\u804c\u4f4d[" + positionLevelCode + "]\u6240\u5728\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            EngineOrgEntity engineOrgEntity = (EngineOrgEntity)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.engineOrgService.lambdaQuery().eq(EngineOrgEntity::getOrgCode, (Object)orgCode)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{EngineOrgEntity::getId}).one()));
            Assert.notNull((Object)((Object)engineOrgEntity), (String)("\u804c\u4f4d[" + positionLevelCode + "]\u6240\u5c5e\u7ec4\u7ec7[" + orgCode + "]\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528"));
            EnginePositionEntity enginePositionEntity = new EnginePositionEntity();
            String positionCode = CodeUtil.getCode();
            enginePositionEntity.setPositionCode(positionCode);
            enginePositionEntity.setPositionName(this.convertPositionName(enginePositionEntities, mdmPositionLevelEntity));
            enginePositionEntity.setIsPrimary(engineUserPositionVo.getIsPrimary());
            enginePositionEntity.setPositionLevelCode(positionLevelCode);
            enginePositionEntity.setParentId(engineUserPositionVo.getParentPositionId());
            enginePositionEntity.setOrganizationId(engineOrgEntity.getId());
            this.enginePositionService.save((Object)enginePositionEntity);
            this.maintainPositionAndRole((EngineUserPositionVo)engineUserPositionVo, positionCode);
        });
        engineUserPositionVos.stream().filter(engineUserPositionVo -> "h".equals(engineUserPositionVo.getOperationType())).forEach(engineUserPositionVo -> {
            String positionCode = engineUserPositionVo.getPositionCode();
            Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            ((LambdaUpdateChainWrapper)this.engineRolePositionService.lambdaUpdate().eq(EngineRolePositionEntity::getPositionCode, (Object)engineUserPositionVo.getPositionCode())).remove();
            this.maintainPositionAndRole((EngineUserPositionVo)engineUserPositionVo, positionCode);
        });
    }

    private void maintainPositionAndRole(EngineUserPositionVo engineUserPositionVo, String positionCode) {
        List processRuleCodeList;
        List roleCodeList = engineUserPositionVo.getRoleCodeList();
        if (!CollectionUtils.isEmpty((Collection)roleCodeList)) {
            List engineRolePositionEntities = roleCodeList.stream().map(x -> new EngineRolePositionEntity(x + positionCode, positionCode, (String)x)).collect(Collectors.toList());
            this.engineRolePositionService.saveOrUpdateBatch(engineRolePositionEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)(processRuleCodeList = engineUserPositionVo.getProcessRuleCodeList()))) {
            List engineRolePositionEntities = processRuleCodeList.stream().map(x -> new EngineRolePositionEntity(x + positionCode, positionCode, (String)x)).collect(Collectors.toList());
            this.engineRolePositionService.saveOrUpdateBatch(engineRolePositionEntities);
        }
    }

    private String convertPositionName(List<EnginePositionEntity> enginePositionEntities, MdmPositionLevelEntity mdmPositionLevelEntity) {
        String positionLevelName = mdmPositionLevelEntity.getName();
        if (CollectionUtils.isEmpty(enginePositionEntities)) {
            return positionLevelName + "_1";
        }
        return enginePositionEntities.stream().map(EnginePositionEntity::getPositionName).max(Comparator.comparing(positionName -> this.getPositionNameSuffix(positionLevelName, (String)positionName))).map(x -> positionLevelName + "_" + x + 1).orElse(positionLevelName + "_1");
    }

    private Integer getPositionNameSuffix(String positionLevelName, String positionName) {
        if (StringUtils.isEmpty((String)positionName) || !positionLevelName.startsWith(positionName)) {
            return 0;
        }
        String suffix = positionName.substring(positionName.lastIndexOf("_") + 1);
        if (!suffix.matches("^[1-9]\\d*$")) {
            return 0;
        }
        return Integer.valueOf(suffix);
    }

    private void checkUser(EngineUserViewVo engineUserViewVo) {
        String userAccount = engineUserViewVo.getUserAccount();
        Assert.hasText((String)userAccount, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String userPassword = engineUserViewVo.getUserPassword();
        Assert.hasText((String)userPassword, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String userType = engineUserViewVo.getUserType();
        Assert.isTrue(("y".equals(userType) || "n".equals(userType) ? 1 : 0) != 0, (String)"\u7528\u6237\u7c7b\u578b\u5fc5\u586b");
        EngineUserEntity one = (EngineUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineUserEntity::getUserAccount, (Object)userAccount)).one());
        Assert.isNull((Object)((Object)one), (String)("\u5e10\u53f7[" + userAccount + "]\u5df2\u5b58\u5728"));
        List engineUserPositionVos = engineUserViewVo.getEngineUserPositionVos();
        Assert.notEmpty((Collection)engineUserPositionVos, (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        long count = engineUserPositionVos.stream().filter(x -> PrimaryPositionEnum.Y.getCode().equals(x.getIsPrimary())).count();
        if (count != 1L) {
            engineUserPositionVos = engineUserPositionVos.stream().peek(x -> x.setIsPrimary(PrimaryPositionEnum.N.getCode())).collect(Collectors.toList());
            ((EngineUserPositionVo)engineUserPositionVos.get(0)).setIsPrimary(PrimaryPositionEnum.Y.getCode());
            engineUserViewVo.setEngineUserPositionVos(engineUserPositionVos);
        }
    }

    @Override
    public void update(EngineUserViewVo engineUserViewVo) {
        String id = engineUserViewVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkUser(engineUserViewVo);
        this.postUser(engineUserViewVo);
        this.updateById(CrmBeanUtil.copy((Object)engineUserViewVo, EngineUserEntity.class));
    }

    @Override
    public void deleteBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(ids);
    }

    @Override
    public void enableBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public void disableBatch(EngineUserReqVo engineUserReqVo) {
        List ids = engineUserReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }
}

