/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelDetailReqVo;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelRoleReqVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelDetailRespVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelRoleRespVo;
import com.biz.crm.position.mapper.MdmPositionLevelMapper;
import com.biz.crm.position.model.MdmPositionLevelEntity;
import com.biz.crm.position.service.IMdmPositionLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionLevelServiceExpandImpl"})
public class MdmPositionLevelServiceImpl
extends ServiceImpl<MdmPositionLevelMapper, MdmPositionLevelEntity>
implements IMdmPositionLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelServiceImpl.class);
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;

    @Override
    public PageResult<MdmPositionLevelRespVo> findList(MdmPositionLevelReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPositionLevelRespVo> list = this.mdmPositionLevelMapper.findList((Page<MdmPositionLevelRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionLevelRespVo query(MdmPositionLevelReqVo reqVo) {
        MdmPositionLevelEntity entity;
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            wrapper.eq((Object)"id", (Object)reqVo.getId());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPositionLevelCode())) {
            wrapper.eq((Object)"code", (Object)reqVo.getPositionLevelCode());
        }
        if ((entity = (MdmPositionLevelEntity)((Object)this.mdmPositionLevelMapper.selectOne((Wrapper)wrapper))) == null) {
            throw new BusinessException("\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmPositionLevelRespVo.class);
        respVo.setPositionLevelCode(entity.getCode());
        respVo.setPositionLevelName(entity.getName());
        ArrayList<MdmPositionLevelRoleRespVo> roleList = new ArrayList<MdmPositionLevelRoleRespVo>();
        if (StringUtils.isNotEmpty((String)respVo.getRoleCode())) {
            List<String> codes = Arrays.asList(respVo.getRoleCode().split(","));
            roleList.addAll(this.mdmPositionLevelMapper.roleSelectListByCodes(codes));
        }
        respVo.setRoleList(roleList);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPositionLevelReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getPositionLevelName())) {
            throw new BusinessException("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleCode())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleName())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u540d\u79f0");
        }
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionLevelEntity.class));
        entity.setCode(CodeUtil.getCode());
        entity.setName(reqVo.getPositionLevelName());
        entity.setCreateTime(new Date());
        entity.setCreateUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
        entity.setDeleteFlag(0);
        entity.setState(1);
        this.save((Object)entity);
        for (String roleCode : entity.getRoleCode().split(",")) {
            this.mdmPositionLevelMapper.insertPositionLevelRoleInEngine(UUID.randomUUID().toString(), entity.getCode(), roleCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionLevelReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u7f3a\u5931id");
        }
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)reqVo.getPositionLevelName())) {
            throw new BusinessException("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleCode())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleName())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getEnableStatus())) {
            throw new BusinessException("\u7f3a\u5931\u542f\u7528\u72b6\u6001");
        }
        entity.setName(reqVo.getPositionLevelName());
        entity.setRoleCode(reqVo.getRoleCode());
        entity.setRoleName(reqVo.getRoleName());
        entity.setEnableStatus(reqVo.getEnableStatus());
        entity.setState(CrmEnableStatusEnum.ENABLE.getCode().equals(reqVo.getEnableStatus()) ? 1 : 0);
        entity.setModifyDate(new Date());
        entity.setModifyUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
        this.updateById((Object)entity);
        this.mdmPositionLevelMapper.deletePositionLevelRoleInEngine(entity.getCode());
        for (String roleCode : entity.getRoleCode().split(",")) {
            this.mdmPositionLevelMapper.insertPositionLevelRoleInEngine(UUID.randomUUID().toString(), entity.getCode(), roleCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPositionLevelReqVo reqVo) {
        List list = this.mdmPositionLevelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                this.removeById((Serializable)((Object)o.getId()));
                this.mdmPositionLevelMapper.deletePositionLevelRoleInEngine(o.getCode());
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPositionLevelReqVo reqVo) {
        List list = this.mdmPositionLevelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                o.setState(1);
                o.setModifyUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
                o.setModifyDate(new Date());
            });
        }
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPositionLevelReqVo reqVo) {
        List list = this.mdmPositionLevelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                o.setState(0);
                o.setModifyUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
                o.setModifyDate(new Date());
            });
        }
        this.updateBatchById(list);
    }

    @Override
    public PageResult<MdmPositionLevelDetailRespVo> positionList(MdmPositionLevelDetailReqVo mdmPositionLevelDetailReqVo) {
        Page page = new Page((long)mdmPositionLevelDetailReqVo.getPageNum().intValue(), (long)mdmPositionLevelDetailReqVo.getPageSize().intValue());
        List<MdmPositionLevelDetailRespVo> list = this.mdmPositionLevelMapper.positionList((Page<MdmPositionLevelDetailRespVo>)page, mdmPositionLevelDetailReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmPositionLevelRoleRespVo> roleSelectList(MdmPositionLevelRoleReqVo mdmPositionLevelRoleReqVo) {
        return this.mdmPositionLevelMapper.roleSelectList(mdmPositionLevelRoleReqVo);
    }

    @Override
    public List<MdmPositionLevelRespVo> selectList(MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelCode()), MdmPositionLevelEntity::getCode, (Object)mdmPositionLevelReqVo.getPositionLevelCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelName()), MdmPositionLevelEntity::getName, (Object)mdmPositionLevelReqVo.getPositionLevelName())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return list != null ? list.stream().map(item -> {
            MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)item, MdmPositionLevelRespVo.class);
            respVo.setPositionLevelCode(item.getCode());
            respVo.setPositionLevelName(item.getName());
            return respVo;
        }).collect(Collectors.toList()) : new ArrayList<MdmPositionLevelRespVo>();
    }
}

