/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.priceconditiongroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.mdm.priceconditiongroup.req.MdmPriceConditionGroupRelFieldReqVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupEntity;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.priceconditiongroup.service.impl.MdmPriceConditionGroupRelFieldServiceImpl;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PriceConditionGroupServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceConditionGroupServiceHelper.class);
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldServiceImpl mdmPriceConditionGroupRelFieldService;

    public void saveCheck(MdmPriceConditionGroupReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getConditionGroupCode())) {
            String oneCode = CodeUtil.createOneCode((String)"mdm_price_condition_group");
            AssertUtils.isNotEmpty((String)oneCode, (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219");
            reqVo.setConditionGroupCode(oneCode);
        }
        this.saveAndEditCheck(reqVo);
        List entities = this.mdmPriceConditionGroupMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode())).or()).eq(MdmPriceConditionGroupEntity::getGroupCodesKey, (Object)reqVo.getGroupCodesKey()));
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)entities), (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u6216\u8005\u6761\u4ef6\u7f16\u7801\u7ec4\u5408key\u5df2\u5b58\u5728");
    }

    public void editCheck(MdmPriceConditionGroupReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceConditionGroupEntity mdmPriceConditionGroupEntity = (MdmPriceConditionGroupEntity)((Object)this.mdmPriceConditionGroupMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        reqVo.setConditionGroupCode(mdmPriceConditionGroupEntity.getConditionGroupCode());
        AssertUtils.isNotNull((Object)((Object)mdmPriceConditionGroupEntity), (String)"\u8be5\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)mdmPriceConditionGroupEntity.getIsRelated()), (String)"\u5173\u8054\u4e86\u6761\u4ef6\u7c7b\u578b\u5c31\u4e0d\u80fd\u7f16\u8f91");
        this.saveAndEditCheck(reqVo);
        List entities = this.mdmPriceConditionGroupMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupEntity::getGroupCodesKey, (Object)reqVo.getGroupCodesKey())).ne(BaseIdEntity::getId, (Object)reqVo.getId()));
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)entities), (String)"\u6761\u4ef6\u7f16\u7801\u7ec4\u5408key\u5df2\u5b58\u5728");
    }

    public void saveAndEditCheck(MdmPriceConditionGroupReqVo reqVo) {
        List conditionFieldList = reqVo.getConditionFieldList();
        AssertUtils.isNotEmpty((Collection)conditionFieldList, (String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u4fe1\u606f");
        HashSet<String> collect = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < conditionFieldList.size(); ++i) {
            String fieldCode = ((MdmPriceConditionGroupRelFieldReqVo)conditionFieldList.get(i)).getFieldCode();
            AssertUtils.isNotEmpty((String)fieldCode, (String)"\u9009\u62e9\u7684\u5b57\u6bb5\u4fe1\u606f\u7f16\u7801\u4e3a\u7a7a");
            collect.add(fieldCode);
            sb.append(fieldCode);
            if (i == conditionFieldList.size() - 1) continue;
            sb.append("/");
        }
        reqVo.setGroupCodesKey(sb.toString());
        AssertUtils.isTrue((conditionFieldList.size() == collect.size() ? 1 : 0) != 0, (String)"\u9009\u62e9\u7684\u5b57\u6bb5\u4fe1\u606f\u91cd\u590d");
    }

    public void saveOrUpdatePriceConditionGroupRelFields(MdmPriceConditionGroupReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List ids = reqVo.getConditionFieldList().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.mdmPriceConditionGroupRelFieldMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode())).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
        }
        List mdmPriceConditionGroupRelFieldEntities = reqVo.getConditionFieldList().stream().map(o -> {
            MdmPriceConditionGroupRelFieldEntity entity = new MdmPriceConditionGroupRelFieldEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)entity));
            entity.setConditionGroupCode(reqVo.getConditionGroupCode());
            entity.setFormInstanceId(reqVo.getFormInstanceId());
            return entity;
        }).collect(Collectors.toList());
        this.mdmPriceConditionGroupRelFieldService.saveOrUpdateBatch(mdmPriceConditionGroupRelFieldEntities);
    }
}

