/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.priceconditiontype.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.mdm.priceconditiontype.req.MdmPriceConditionTypeRelGroupReqVo;
import com.biz.crm.nebular.mdm.priceconditiontype.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.priceconditiontype.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.priceconditiontype.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.priceconditiontype.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.priceconditiontype.mapper.MdmPriceConditionTypeRelGroupMapper;
import com.biz.crm.priceconditiontype.model.MdmPriceConditionTypeEntity;
import com.biz.crm.priceconditiontype.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.priceconditiontype.service.impl.MdmPriceConditionTypeRelGroupServiceImpl;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PriceConditionTypeServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceConditionTypeServiceHelper.class);
    @Resource
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;
    @Resource
    private MdmPriceConditionTypeRelGroupMapper mdmPriceConditionTypeRelGroupMapper;
    @Resource
    private MdmPriceConditionTypeRelGroupServiceImpl mdmPriceConditionTypeRelGroupService;
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;

    public void saveCheck(MdmPriceConditionTypeReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getConditionTypeCode())) {
            String oneCode = CodeUtil.createOneCode((String)"mdm_price_condition_type");
            AssertUtils.isNotNull((Object)oneCode, (String)"\u6761\u4ef6\u5b57\u6bb5\u7c7b\u578b\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219");
            reqVo.setConditionTypeCode(oneCode);
        }
        this.saveAndEditCheck(reqVo);
    }

    public void editCheck(MdmPriceConditionTypeReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceConditionTypeEntity mdmPriceConditionTypeEntity = (MdmPriceConditionTypeEntity)((Object)this.mdmPriceConditionTypeMapper.selectById((Serializable)((Object)reqVo.getId())));
        reqVo.setConditionTypeCode(mdmPriceConditionTypeEntity.getConditionTypeCode());
        AssertUtils.isNotNull((Object)((Object)mdmPriceConditionTypeEntity), (String)"\u8be5\u6761\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)mdmPriceConditionTypeEntity.getIsRelated()), (String)"\u5173\u8054\u4e86\u5b9a\u4ef7\u8fc7\u7a0b\u4e0d\u80fd\u7f16\u8f91");
        this.saveAndEditCheck(reqVo);
    }

    public void saveAndEditCheck(MdmPriceConditionTypeReqVo reqVo) {
        List mdmPriceConditionTypeRelGroupReqVos = reqVo.getConditionTypeRelGroupReqVoList();
        AssertUtils.isNotEmpty((Collection)mdmPriceConditionTypeRelGroupReqVos, (String)"\u8bf7\u9009\u62e9\u6761\u4ef6\u5206\u7c7b");
        HashSet<String> collect = new HashSet<String>();
        for (int i = 0; i < mdmPriceConditionTypeRelGroupReqVos.size(); ++i) {
            String conditionGroupCode = ((MdmPriceConditionTypeRelGroupReqVo)mdmPriceConditionTypeRelGroupReqVos.get(i)).getConditionGroupCode();
            AssertUtils.isNotNull((Object)conditionGroupCode, (String)"\u9009\u62e9\u7684\u6761\u4ef6\u5206\u7c7b\u4fe1\u606f\u7f16\u7801\u4e3a\u7a7a");
            collect.add(conditionGroupCode);
        }
        AssertUtils.isTrue((mdmPriceConditionTypeRelGroupReqVos.size() == collect.size() ? 1 : 0) != 0, (String)"\u9009\u62e9\u7684\u6761\u4ef6\u5206\u7c7b\u91cd\u590d");
    }

    public void saveOrUpdatePriceConditionTypeRelGroups(MdmPriceConditionTypeReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List conditionGroupCodes1 = reqVo.getConditionTypeRelGroupReqVoList().stream().map(MdmPriceConditionTypeRelGroupReqVo::getConditionGroupCode).collect(Collectors.toList());
            reqVo.setIds(Arrays.asList(reqVo.getId()));
            List<String> conditionGroupCodes2 = this.mdmPriceConditionTypeMapper.findGroupCodesByIds(reqVo);
            List<String> conditionGroupCodes3 = conditionGroupCodes2.stream().filter(o -> !conditionGroupCodes1.contains(o)).collect(Collectors.toList());
            List<MdmPriceConditionTypeRelGroupRespVo> mdmPriceConditionTypeRelGroupRespVos = null;
            if (CollectionUtil.listNotEmpty(conditionGroupCodes3) && CollectionUtil.listNotEmpty(mdmPriceConditionTypeRelGroupRespVos = this.mdmPriceConditionTypeRelGroupMapper.countRelatedRecordsByGroupCodes(conditionGroupCodes3))) {
                List<String> updateIsRelatedConditionGroupCodes = mdmPriceConditionTypeRelGroupRespVos.stream().filter(o -> o.getCountConditionGroupRecords() == 1).map(MdmPriceConditionTypeRelGroupRespVo::getConditionGroupCode).collect(Collectors.toList());
                this.mdmPriceConditionGroupMapper.updateIsRelatedNoByConditionGroupCode(updateIsRelatedConditionGroupCodes);
            }
            List ids = reqVo.getConditionTypeRelGroupReqVoList().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.mdmPriceConditionTypeRelGroupMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, (Object)reqVo.getConditionTypeCode())).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
        }
        List mdmPriceConditionTypeRelGroupEntities = reqVo.getConditionTypeRelGroupReqVoList().stream().map(o -> {
            MdmPriceConditionTypeRelGroupEntity entity = new MdmPriceConditionTypeRelGroupEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)entity));
            entity.setConditionTypeCode(reqVo.getConditionTypeCode());
            entity.setFormInstanceId(reqVo.getFormInstanceId());
            return entity;
        }).collect(Collectors.toList());
        this.mdmPriceConditionTypeRelGroupService.saveOrUpdateBatch(mdmPriceConditionTypeRelGroupEntities);
        List<String> conditionGroupCodes = reqVo.getConditionTypeRelGroupReqVoList().stream().map(MdmPriceConditionTypeRelGroupReqVo::getConditionGroupCode).collect(Collectors.toList());
        this.mdmPriceConditionGroupMapper.updateIsRelatedYesByConditionGroupCode(conditionGroupCodes);
    }

    public void convertListDate(List<MdmPriceConditionTypeRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getConditionTypeType())) {
                    o.setConditionTypeTypeName((String)((Map)Optional.ofNullable(map.get("condition_type_type")).orElse(Maps.newHashMap())).get(o.getConditionTypeType()));
                }
            });
        }
    }

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("condition_type_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }
}

