/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.product.mapper.MdmProductMaterialMapper;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.service.IMdmProductMaterialService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmProductMaterialServiceImpl
extends ServiceImpl<MdmProductMaterialMapper, MdmProductMaterialEntity>
implements IMdmProductMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductMaterialServiceImpl.class);
    @Autowired
    private MdmProductMaterialMapper mdmProductMaterialMapper;

    @Override
    public PageResult<MdmProductMaterialRespVo> findList(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        QueryWrapper wrapper;
        Page page = new Page((long)mdmProductMaterialReqVo.getPageNum().intValue(), (long)mdmProductMaterialReqVo.getPageSize().intValue());
        List<MdmProductMaterialRespVo> list = this.mdmProductMaterialMapper.findList((Page<MdmProductMaterialRespVo>)page, (QueryWrapper<MdmProductMaterialRespVo>)(wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((CharSequence)mdmProductMaterialReqVo.getId()), (Object)"a.id", (Object)mdmProductMaterialReqVo.getId())).like(!StringUtils.isEmpty((CharSequence)mdmProductMaterialReqVo.getProductCode()), (Object)"a.product_code", (Object)mdmProductMaterialReqVo.getProductCode())).eq((Object)"a.enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode())));
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList dictCodes = Lists.newArrayList();
            dictCodes.add("material_base_unit");
            dictCodes.add("material_sale_unit");
            Map map = DictUtil.getDictValueMapsByCodes((List)dictCodes);
            list.stream().forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getSaleUnitName())) {
                    o.setSaleUnitName((String)((Map)Optional.ofNullable(map.get("material_sale_unit")).orElse(Maps.newHashMap())).get(o.getSaleUnitName()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getBaseUnitName())) {
                    o.setBaseUnitName((String)((Map)Optional.ofNullable(map.get("material_base_unit")).orElse(Maps.newHashMap())).get(o.getBaseUnitName()));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductMaterialRespVo query(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((CharSequence)mdmProductMaterialReqVo.getProductCode()), (Object)"product_code", (Object)mdmProductMaterialReqVo);
        return (MdmProductMaterialRespVo)CrmBeanUtil.copy((Object)this.getOne((Wrapper)wrapper, false), MdmProductMaterialRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        MdmProductMaterialEntity entity = (MdmProductMaterialEntity)((Object)CrmBeanUtil.copy((Object)mdmProductMaterialReqVo, MdmProductMaterialEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        MdmProductMaterialEntity entity = (MdmProductMaterialEntity)((Object)this.getById((Serializable)((Object)mdmProductMaterialReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }
}

